/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import java.util.Arrays;
import net.paulhertz.pixelaudio.Lindenmayer;
import net.paulhertz.pixelaudio.PixelAudioMapper;

public class Argosy {
    PixelAudioMapper mapper;
    int[] argosyArray;
    int argosyUnitSize;
    int argosyStep;
    float animStepDivisor = 16.0f;
    int bgColor = PixelAudioMapper.composeColor(0, 0, 0, 0);
    int[] argosyColors = new int[]{PixelAudioMapper.composeColor(255, 255, 255, 255), PixelAudioMapper.composeColor(0, 0, 0, 255)};
    float argosyGapScale = 1.0f;
    int argosyGap;
    int argosyGapColor = PixelAudioMapper.composeColor(127, 127, 127, 255);
    int argosyReps = 0;
    int maxReps;
    int argosyMargin;
    int[] argosyPattern;
    int argosySize;
    boolean isCentered = true;
    int[] argosyIntervals;
    int argosyPixelShift = 0;
    boolean isCountShift = true;
    int argosyShiftStep = 0;
    int argosyOffset = 0;
    public static final int[] argosy55 = new int[]{2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2};

    public Argosy(PixelAudioMapper mapper, int unitSize, int reps, boolean isCentered) {
        this.mapper = mapper;
        int size = mapper.getSize();
        this.argosyArray = new int[size];
        this.argosyUnitSize = unitSize;
        this.argosyPattern = new int[argosy55.length];
        int i = 0;
        while (i < argosy55.length) {
            this.argosyPattern[i] = argosy55[i];
            ++i;
        }
        this.argosyStep = Math.round((float)this.argosyUnitSize / this.animStepDivisor);
        if (this.argosyStep == 0) {
            this.argosyStep = 1;
        }
        this.argosyGap = Math.round(this.argosyGapScale * (float)this.argosyUnitSize);
        this.argosyReps = reps;
        this.isCentered = isCentered;
        this.initArgosy();
    }

    public Argosy(PixelAudioMapper mapper, int unitSize, int reps, boolean isCentered, int[] colors, int gapColor, float gapScale, int[] pattern) {
        this.mapper = mapper;
        int size = mapper.getSize();
        this.argosyArray = new int[size];
        this.argosyUnitSize = unitSize;
        this.argosyPattern = new int[pattern.length];
        int i = 0;
        while (i < pattern.length) {
            this.argosyPattern[i] = pattern[i];
            ++i;
        }
        this.argosyStep = Math.round((float)this.argosyUnitSize / this.animStepDivisor);
        if (this.argosyStep == 0) {
            this.argosyStep = 1;
        }
        this.argosyReps = reps;
        this.isCentered = isCentered;
        this.argosyColors = colors;
        this.argosyGapColor = gapColor;
        this.argosyGapScale = gapScale;
        this.argosyGap = Math.round(this.argosyGapScale * (float)this.argosyUnitSize);
        this.initArgosy();
    }

    public Argosy(PixelAudioMapper mapper, int[] pattern, int unitSize, int reps, boolean isCentered, int[] colors, int gap, int gapColor, int animStep) {
        this.mapper = mapper;
        int size = mapper.getSize();
        this.argosyArray = new int[size];
        this.argosyPattern = new int[pattern.length];
        int i = 0;
        while (i < pattern.length) {
            this.argosyPattern[i] = pattern[i];
            ++i;
        }
        this.argosyUnitSize = unitSize;
        this.argosyReps = reps;
        this.isCentered = isCentered;
        this.argosyColors = colors;
        this.argosyGap = gap;
        this.argosyGapScale = (float)this.argosyGap / (float)this.argosyUnitSize;
        this.argosyGapColor = gapColor;
        this.argosyStep = animStep;
        this.initArgosy();
    }

    public void initArgosy() {
        this.argosyStep = Math.round((float)this.argosyUnitSize / this.animStepDivisor);
        if (this.argosyStep == 0) {
            this.argosyStep = 1;
        }
        this.argosySize = 0;
        int[] nArray = this.argosyPattern;
        int n = this.argosyPattern.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            this.argosySize += element;
            ++n2;
        }
        Arrays.fill(this.argosyArray, this.bgColor);
        int size = this.argosyArray.length;
        this.maxReps = Math.round(size / (this.argosySize * this.argosyUnitSize + this.argosyGap));
        if (this.argosyReps != 0 && this.argosyReps < this.maxReps) {
            this.maxReps = this.argosyReps;
        }
        if (this.isCentered) {
            this.argosyMargin = size - (this.maxReps * (this.argosySize * this.argosyUnitSize) + this.maxReps * (this.argosyGap - 1));
            this.argosyMargin /= 2;
        } else {
            this.argosyMargin = 0;
        }
        this.argosyIntervals = new int[this.argosyPattern.length];
        int i = 0;
        while (i < this.argosyPattern.length) {
            this.argosyIntervals[i] = this.argosyPattern[i] * this.argosyUnitSize;
            ++i;
        }
        this.argosyPixelShift = 0;
        this.argosyFill();
    }

    public void argosyFill() {
        int size = this.argosyArray.length;
        int reps = 0;
        int vi = 0;
        int ci = 0;
        int si = 0;
        int i = 0;
        if (this.isCentered) {
            si += this.argosyMargin;
        }
        while (si < size) {
            i = si;
            while (i < si + this.argosyIntervals[vi]) {
                if (i >= size) break;
                this.argosyArray[i] = this.argosyColors[ci];
                ++i;
            }
            si = i;
            ci = (ci + 1) % this.argosyColors.length;
            vi = (vi + 1) % this.argosyIntervals.length;
            if (vi == 0) {
                ++reps;
                i = si;
                while (i < si + this.argosyGap) {
                    if (i >= size) break;
                    this.argosyArray[i] = this.argosyGapColor;
                    ++i;
                }
                si = i;
            }
            if (reps == this.maxReps) break;
        }
    }

    public void rotateLeft(int d) {
        int[] arr = this.argosyArray;
        d = d < 0 ? arr.length - -d % arr.length : (d %= arr.length);
        this.reverseArray(arr, 0, d - 1);
        this.reverseArray(arr, d, arr.length - 1);
        this.reverseArray(arr, 0, arr.length - 1);
        if (this.isCountShift) {
            this.argosyPixelShift += d;
            this.argosyPixelShift %= this.mapper.getSize();
        }
    }

    private void reverseArray(int[] arr, int l, int r) {
        while (l < r) {
            int temp = arr[l];
            arr[l] = arr[r];
            arr[r] = temp;
            ++l;
            --r;
        }
    }

    public void shiftRight() {
        this.rotateLeft(-this.argosyStep);
        --this.argosyShiftStep;
    }

    public void shiftLeft() {
        this.rotateLeft(this.argosyStep);
        ++this.argosyShiftStep;
    }

    public int getArgosyPixelShift() {
        return this.argosyPixelShift;
    }

    public void setArgosyPixelShift(int newShift) {
        this.argosyPixelShift = newShift;
    }

    public void zeroArgosyPixelShift() {
        this.setArgosyPixelShift(0);
    }

    public void shift(int pixelShift, boolean isCounted) {
        boolean oldCountShift = this.isCountShift;
        this.isCountShift = isCounted;
        this.rotateLeft(pixelShift);
        this.isCountShift = oldCountShift;
    }

    public int[] getArgosyArray() {
        return this.argosyArray;
    }

    public int[] getArgosyArrayCopy() {
        return Arrays.copyOf(this.argosyArray, this.argosyArray.length);
    }

    public void setArgosyArray(int[] newArgosyArray) {
        if (newArgosyArray.length != this.argosyArray.length) {
            System.out.println("----->>> ERROR : new argosy array must be the same size as the old array!");
            return;
        }
        int i = 0;
        while (i < newArgosyArray.length) {
            this.argosyArray[i] = newArgosyArray[i];
            ++i;
        }
    }

    public float[] getArgosySignal() {
        float[] signal = new float[this.argosyArray.length];
        float[] hsbPixel = new float[3];
        return PixelAudioMapper.pullPixelAsAudio(this.argosyArray, signal, PixelAudioMapper.ChannelNames.L, hsbPixel);
    }

    public float[] getArgosySignal(PixelAudioMapper.ChannelNames chan) {
        float[] signal = new float[this.argosyArray.length];
        float[] hsbPixel = new float[3];
        return PixelAudioMapper.pullPixelAsAudio(this.argosyArray, signal, chan, hsbPixel);
    }

    public float[] getArgosySignal(float scale) {
        float[] signal = new float[this.argosyArray.length];
        float[] hsbPixel = new float[3];
        PixelAudioMapper.pullPixelAsAudio(this.argosyArray, signal, PixelAudioMapper.ChannelNames.L, hsbPixel);
        int i = 0;
        while (i < signal.length) {
            int n = i++;
            signal[n] = signal[n] * scale;
        }
        return signal;
    }

    public float[] getArgosySignal(PixelAudioMapper.ChannelNames chan, float scale) {
        float[] signal = new float[this.argosyArray.length];
        float[] hsbPixel = new float[3];
        PixelAudioMapper.pullPixelAsAudio(this.argosyArray, signal, chan, hsbPixel);
        int i = 0;
        while (i < signal.length) {
            int n = i++;
            signal[n] = signal[n] * scale;
        }
        return signal;
    }

    public int getArgosySize() {
        return this.argosySize;
    }

    public int getUnitSize() {
        return this.argosyUnitSize;
    }

    public void setUnitSize(int unitSize) {
        this.argosyUnitSize = unitSize;
        this.argosyStep = Math.round((float)this.argosyUnitSize / this.animStepDivisor);
        if (this.argosyStep == 0) {
            this.argosyStep = 1;
        }
        this.initArgosy();
    }

    public int getArgosyStep() {
        return this.argosyStep;
    }

    public void setArgosyStep(int argoStep) {
        this.argosyStep = argoStep;
    }

    public int[] getArgosyColors() {
        return this.argosyColors;
    }

    public void setArgosyColors(int[] argosyColors) {
        this.argosyColors = argosyColors;
        this.initArgosy();
    }

    public float getArgosyGapScale() {
        return this.argosyGapScale;
    }

    public void setArgosyGapScale(float argosyGapScale) {
        this.argosyGapScale = argosyGapScale;
        this.argosyGap = Math.round(this.argosyGapScale * (float)this.argosyUnitSize);
        this.initArgosy();
    }

    public int getArgosyGap() {
        return this.argosyGap;
    }

    public void setArgosyGap(int argosyGap) {
        this.argosyGap = argosyGap;
        this.argosyGapScale = (float)this.argosyGap / (float)this.argosyUnitSize;
        this.initArgosy();
    }

    public int getArgosyGapColor() {
        return this.argosyGapColor;
    }

    public void setArgosyGapColor(int argosyGapColor) {
        this.argosyGapColor = argosyGapColor;
        this.initArgosy();
    }

    public int getArgosyReps() {
        return this.argosyReps;
    }

    public void setArgosyReps(int newReps) {
        this.argosyReps = newReps;
        this.initArgosy();
    }

    public PixelAudioMapper getMapper() {
        return this.mapper;
    }

    public int getArgosyMargin() {
        return this.argosyMargin;
    }

    public int getArgosyOffset() {
        return this.argosyOffset;
    }

    public void setArgosyOffset(int argosyOffset) {
        this.argosyOffset = argosyOffset;
        this.shift(argosyOffset, false);
    }

    public int getMaxReps() {
        return this.maxReps;
    }

    public int[] getArgosyPattern() {
        return this.argosyPattern;
    }

    public void setArgosyPattern(int[] pattern) {
        this.argosyPattern = new int[pattern.length];
        int i = 0;
        while (i < pattern.length) {
            this.argosyPattern[i] = pattern[i];
            ++i;
        }
        this.initArgosy();
    }

    public void setNewColors(int[] argosyColors, int argosyGapColor) {
        this.argosyColors = argosyColors;
        this.argosyGapColor = argosyGapColor;
        this.initArgosy();
    }

    public float getAnimStepDivisor() {
        return this.animStepDivisor;
    }

    public void setAnimStepDivisor(float animStepDivisor) {
        this.animStepDivisor = animStepDivisor;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public static ArrayList<String> fibo(int depth, boolean verbose) {
        Lindenmayer lind = new Lindenmayer();
        lind.put("0", "1");
        lind.put("1", "01");
        ArrayList<String> buf = new ArrayList<String>();
        ArrayList<String> seed = new ArrayList<String>();
        seed.add("0");
        lind.expandString(seed, depth, buf);
        if (verbose) {
            System.out.println("Fibonacci L-system at depth " + depth + "\n");
            for (String element : buf) {
                System.out.print(element);
            }
        }
        return buf;
    }

    public static int[] fibonacciPattern(int depth, int v1, int v2, boolean verbose) {
        ArrayList<String> buf = Argosy.fibo(depth, verbose);
        int[] argo = new int[buf.size()];
        int i = 0;
        while (i < argo.length) {
            int gen = Integer.valueOf(buf.get(i));
            argo[i] = gen == 0 ? v1 : v2;
            ++i;
        }
        if (verbose) {
            System.out.println("\n----- argosy pattern: ");
            i = 0;
            while (i < argo.length - 1) {
                System.out.print(argo[i] + ", ");
                ++i;
            }
            System.out.println(argo[i]);
        }
        return argo;
    }
}

