/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

public class AudioColorTranscoder {
    private final float minAudio;
    private final float maxAudio;
    private final int minColor;
    private final int maxColor;

    public AudioColorTranscoder(float minAudio, float maxAudio, int minColor, int maxColor) {
        this.minAudio = minAudio;
        this.maxAudio = maxAudio;
        this.minColor = minColor;
        this.maxColor = maxColor;
    }

    public int transcodeFloat(float val) {
        val = AudioColorTranscoder.clamp(val, this.minAudio, this.maxAudio);
        float norm = (val - this.minAudio) / (this.maxAudio - this.minAudio);
        return Math.round(norm * (float)(this.maxColor - this.minColor) + (float)this.minColor);
    }

    public float transcodeInt(int val) {
        val = AudioColorTranscoder.clamp(val, this.minColor, this.maxColor);
        float norm = (float)(val - this.minColor) / (float)(this.maxColor - this.minColor);
        return norm * (this.maxAudio - this.minAudio) + this.minAudio;
    }

    public float transcodeIntF(float val) {
        val = AudioColorTranscoder.clamp(val, (float)this.minColor, (float)this.maxColor);
        float norm = (val - (float)this.minColor) / (float)(this.maxColor - this.minColor);
        return norm * (this.maxAudio - this.minAudio) + this.minAudio;
    }

    private static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    private static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }
}

