/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.Arrays;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.PixelAudio;
import processing.core.PImage;

public class BitmapTransform {
    public static PImage imageTransform(PImage img, AffineTransformType type) {
        switch (type) {
            case R270: {
                img = BitmapTransform.rotate270(img);
                break;
            }
            case R90: {
                img = BitmapTransform.rotate90(img);
                break;
            }
            case R180: {
                img = BitmapTransform.rotate180(img);
                break;
            }
            case FLIPX: {
                img = BitmapTransform.flipX(img);
                break;
            }
            case FLIPY: {
                img = BitmapTransform.flipY(img);
                break;
            }
            case FX270: {
                img = BitmapTransform.flipX270(img);
                break;
            }
            case FX90: {
                img = BitmapTransform.flipX90(img);
                break;
            }
        }
        return img;
    }

    public static int[] pixelsTransform(int[] pixels, int width, int height, AffineTransformType type) {
        switch (type) {
            case R270: {
                return BitmapTransform.rotate270(pixels, width, height);
            }
            case R90: {
                return BitmapTransform.rotate90(pixels, width, height);
            }
            case R180: {
                return BitmapTransform.rotate180(pixels, width, height);
            }
            case FLIPX: {
                return BitmapTransform.flipX(pixels, width, height);
            }
            case FLIPY: {
                return BitmapTransform.flipY(pixels, width, height);
            }
            case FX270: {
                return BitmapTransform.flipX270(pixels, width, height);
            }
            case FX90: {
                return BitmapTransform.flipX90(pixels, width, height);
            }
            case NADA: {
                return Arrays.copyOf(pixels, pixels.length);
            }
        }
        return Arrays.copyOf(pixels, pixels.length);
    }

    public static int[] coordTransform(int x, int y, int width, int height, AffineTransformType type) {
        switch (type) {
            case R270: {
                return BitmapTransform.rotate270Coord(x, y, width, height);
            }
            case R90: {
                return BitmapTransform.rotate90Coord(x, y, width, height);
            }
            case R180: {
                return BitmapTransform.rotate180Coord(x, y, width, height);
            }
            case FLIPX: {
                return BitmapTransform.flipXCoord(x, y, width, height);
            }
            case FLIPY: {
                return BitmapTransform.flipYCoord(x, y, width, height);
            }
            case FX270: {
                return BitmapTransform.flipX270Coord(x, y, width, height);
            }
            case FX90: {
                return BitmapTransform.flipX90Coord(x, y, width, height);
            }
            case NADA: {
                return BitmapTransform.nadaCoord(x, y, width, height);
            }
        }
        return BitmapTransform.nadaCoord(x, y, width, height);
    }

    public static int[] getIndexMap(int w, int h, AffineTransformType type) {
        switch (type) {
            case R270: {
                return BitmapTransform.rotate270Map(w, h);
            }
            case R90: {
                return BitmapTransform.rotate90Map(w, h);
            }
            case R180: {
                return BitmapTransform.rotate180Map(w, h);
            }
            case FLIPX: {
                return BitmapTransform.flipXMap(w, h);
            }
            case FLIPY: {
                return BitmapTransform.flipYMap(w, h);
            }
            case FX90: {
                return BitmapTransform.flipX90Map(w, h);
            }
            case FX270: {
                return BitmapTransform.flipX270Map(w, h);
            }
            case NADA: {
                return BitmapTransform.nadaMap(w, h);
            }
        }
        return BitmapTransform.nadaMap(w, h);
    }

    public static int[] rotate270(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = height - 1 - y;
                int newY = x++;
                int j = newX + newY * height;
                newPixels[j] = pixels[i];
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] rotate90(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = y;
                int newY = width - 1 - x;
                int j = newX + newY * height;
                newPixels[j] = pixels[i];
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] rotate180(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = width - 1 - x;
                int newY = height - 1 - y;
                int j = newX + newY * width;
                newPixels[j] = pixels[i];
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipX(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = width - 1 - x;
                int newY = y;
                int j = newX + newY * width;
                newPixels[j] = pixels[i];
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipY(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = x++;
                int newY = height - 1 - y;
                int j = newX + newY * width;
                newPixels[j] = pixels[i];
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipX90(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = y;
                int newY = x++;
                int j = newX + newY * height;
                newPixels[j] = pixels[i];
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipX270(int[] pixels, int width, int height) {
        int[] newPixels = new int[pixels.length];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = height - 1 - y;
                int newY = width - 1 - x;
                int j = newX + newY * height;
                newPixels[j] = pixels[i];
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static PImage rotate270(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.rotate270(img.pixels, img.width, img.height);
        img.updatePixels();
        PImage newImage = PixelAudio.myParent.createImage(img.height, img.width, 2);
        newImage.pixels = img.pixels;
        img = newImage;
        return img;
    }

    public static PImage rotate90(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.rotate90(img.pixels, img.width, img.height);
        img.updatePixels();
        PImage newImage = PixelAudio.myParent.createImage(img.height, img.width, 2);
        newImage.pixels = img.pixels;
        img = newImage;
        return img;
    }

    public static PImage rotate180(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.rotate180(img.pixels, img.width, img.height);
        img.updatePixels();
        return img;
    }

    public static PImage flipX(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.flipX(img.pixels, img.width, img.height);
        img.updatePixels();
        return img;
    }

    public static PImage flipY(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.flipY(img.pixels, img.width, img.height);
        img.updatePixels();
        return img;
    }

    public static PImage flipX90(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.flipX90(img.pixels, img.width, img.height);
        img.updatePixels();
        PImage newImage = PixelAudio.myParent.createImage(img.height, img.width, 2);
        newImage.pixels = img.pixels;
        img = newImage;
        return img;
    }

    public static PImage flipX270(PImage img) {
        img.loadPixels();
        img.pixels = BitmapTransform.flipX270(img.pixels, img.width, img.height);
        img.updatePixels();
        PImage newImage = PixelAudio.myParent.createImage(img.height, img.width, 2);
        newImage.pixels = img.pixels;
        img = newImage;
        return img;
    }

    public static int[] rotate270Coord(int x, int y, int w, int h) {
        int newX = h - 1 - y;
        int newY = x;
        return new int[]{newX, newY};
    }

    public static int[] rotate90Coord(int x, int y, int w, int h) {
        int newX = y;
        int newY = w - 1 - x;
        return new int[]{newX, newY};
    }

    public static int[] rotate180Coord(int x, int y, int w, int h) {
        int newX = w - 1 - x;
        int newY = h - 1 - y;
        return new int[]{newX, newY};
    }

    public static int[] flipXCoord(int x, int y, int w, int h) {
        int newX = w - 1 - x;
        int newY = y;
        return new int[]{newX, newY};
    }

    public static int[] flipYCoord(int x, int y, int w, int h) {
        int newX = x;
        int newY = h - 1 - y;
        return new int[]{newX, newY};
    }

    public static int[] flipX90Coord(int x, int y, int w, int h) {
        int newX = y;
        int newY = x;
        return new int[]{newX, newY};
    }

    public static int[] flipX270Coord(int x, int y, int w, int h) {
        int newX = h - 1 - y;
        int newY = w - 1 - x;
        return new int[]{newX, newY};
    }

    public static int[] nadaCoord(int x, int y, int w, int h) {
        return new int[]{x, y};
    }

    public static int[] rotate270Map(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = height - 1 - y;
                int newY = x++;
                int j = newX + newY * height;
                newPixels[j] = i;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] rotate90Map(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = y;
                int newY = width - 1 - x;
                int j = newX + newY * height;
                newPixels[j] = i;
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] rotate180Map(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = width - 1 - x;
                int newY = height - 1 - y;
                int j = newX + newY * width;
                newPixels[j] = i;
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipXMap(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = width - 1 - x;
                int newY = y;
                int j = newX + newY * width;
                newPixels[j] = i;
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipYMap(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = x++;
                int newY = height - 1 - y;
                int j = newX + newY * width;
                newPixels[j] = i;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipX90Map(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = y;
                int newY = x++;
                int j = newX + newY * height;
                newPixels[j] = i;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] flipX270Map(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = x + y * width;
                int newX = height - 1 - y;
                int newY = width - 1 - x;
                int j = newX + newY * height;
                newPixels[j] = i;
                ++x;
            }
            ++y;
        }
        return newPixels;
    }

    public static int[] nadaMap(int width, int height) {
        int[] newPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i;
                newPixels[i] = i = x + y * width;
                ++x;
            }
            ++y;
        }
        return newPixels;
    }
}

