/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.MultiGen;
import net.paulhertz.pixelaudio.PixelAudio;
import net.paulhertz.pixelaudio.PixelMapGen;

public class BoustropheGen
extends PixelMapGen {
    public static final String description = "BoustropheGen starts at (0,0) and reads left-to-right on even numbered pixel scanlines and right-to-left on odd numbered scanlines.";

    public BoustropheGen(int width, int height) {
        super(width, height);
        this.generate();
    }

    public BoustropheGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
        this.generate();
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width < 2 || height < 2) {
            System.out.println("Width and height for BoustropheGen must be greater than 1.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateBouCoordinates(this.w, this.h);
    }

    private ArrayList<int[]> generateBouCoordinates(int width, int height) {
        ArrayList<int[]> coordinates = new ArrayList<int[]>(width * height);
        int y = 0;
        while (y < height) {
            if (y % 2 == 0) {
                x = 0;
                while (x < width) {
                    coordinates.add(new int[]{x++, y});
                }
            } else {
                x = width - 1;
                while (x >= 0) {
                    coordinates.add(new int[]{x--, y});
                }
            }
            ++y;
        }
        return coordinates;
    }

    public static MultiGen boustrophRowRandom(int cols, int rows, int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int y = 0;
        while (y < rows) {
            int x = 0;
            while (x < cols) {
                genList.add(new BoustropheGen(genW, genH, PixelMapGen.randomTransform(PixelAudio.rando())));
                offsetList.add(new int[]{x * genW, y * genH});
                ++x;
            }
            ++y;
        }
        return new MultiGen(cols * genW, rows * genH, offsetList, genList);
    }
}

