/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.PixelMapGen;

public class BuildFromPathGen
extends PixelMapGen {
    public static final String description = "A PixelMapGen that loads data from an external pixelMap, such as might be saved in a JSON file.\nWhen you instantiate a BuildFromPathGen, set the pixelMap field before you call generate().";

    public BuildFromPathGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
    }

    public BuildFromPathGen(int width, int height) {
        super(width, height);
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width < 1 || height < 1) {
            System.out.println("AssembleFromPathGen: width and height must be greater than 0.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        if (this.pixelMap == null && this.coords == null) {
            System.out.println("AssembleFromPathGen: You need to call setPixelMap(int[] newPixelMap) or setCoords(ArrayList<int[]> newCoords) before calling generate().");
            return null;
        }
        if (this.pixelMap != null && this.coords == null) {
            this.coords = new ArrayList(this.pixelMap.length);
            int i = 0;
            while (i < this.pixelMap.length) {
                int pos = this.pixelMap[i];
                int[] xy = new int[]{pos % this.w, pos / this.w};
                this.coords.add(xy);
                ++i;
            }
            if (this.transformType != AffineTransformType.NADA) {
                this.transformCoords(this.coords, this.transformType);
            }
        }
        this.loadIndexMaps();
        return this.pixelMap;
    }

    public void setPixelMap(int[] newPixelMap) {
        this.pixelMap = newPixelMap;
    }
}

