/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.MultiGen;
import net.paulhertz.pixelaudio.PixelMapGen;

public class DiagonalZigzagGen
extends PixelMapGen {
    public static final String description = "DiagonalZigzagGen generates a diagonal zigzag path starting at (0,0) and (0,1), then going diagonally from edge to edge. \nAny width and height greater than 0 are valid for the constructor DiagonalZigzagGen(int width, int height).";

    public DiagonalZigzagGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
        this.generate();
    }

    public DiagonalZigzagGen(int width, int height) {
        super(width, height);
        this.generate();
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width < 1 || height < 1) {
            System.out.println("width and height must be greater than 0.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateZigzagDiagonalCoordinates(this.w, this.h);
    }

    private ArrayList<int[]> generateZigzagDiagonalCoordinates(int width, int height) {
        ArrayList<int[]> coordinates = new ArrayList<int[]>(width * height);
        int x = 0;
        int y = 0;
        boolean movingUp = false;
        while (x < width && y < height) {
            coordinates.add(new int[]{x++, y++});
            if (movingUp) {
                if (x == width - 1) {
                    movingUp = false;
                    continue;
                }
                if (y == 0) {
                    ++x;
                    movingUp = false;
                    continue;
                }
                ++x;
                --y;
                continue;
            }
            if (y == height - 1) {
                movingUp = true;
                continue;
            }
            if (x == 0) {
                ++y;
                movingUp = true;
                continue;
            }
            --x;
            ++y;
        }
        return coordinates;
    }

    public static MultiGen zigzagLoop6x4(int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int[][] nArrayArray = new int[24][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 3;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 4;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[0] = 5;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{5, 1};
        nArrayArray[7] = new int[]{5, 2};
        nArrayArray[8] = new int[]{5, 3};
        nArrayArray[9] = new int[]{4, 3};
        nArrayArray[10] = new int[]{4, 2};
        nArrayArray[11] = new int[]{4, 1};
        nArrayArray[12] = new int[]{3, 1};
        nArrayArray[13] = new int[]{3, 2};
        nArrayArray[14] = new int[]{3, 3};
        nArrayArray[15] = new int[]{2, 3};
        nArrayArray[16] = new int[]{2, 2};
        nArrayArray[17] = new int[]{2, 1};
        nArrayArray[18] = new int[]{1, 1};
        nArrayArray[19] = new int[]{1, 2};
        nArrayArray[20] = new int[]{1, 3};
        int[] nArray6 = new int[2];
        nArray6[1] = 3;
        nArrayArray[21] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 2;
        nArrayArray[22] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[1] = 1;
        nArrayArray[23] = nArray8;
        int[][] locs = nArrayArray;
        AffineTransformType[] trans = new AffineTransformType[]{r90, fx90, r90, fx90, r90, fx90, r270, fx90, r270, fx270, r90, fx270, r270, fx90, r270, fx270, r90, fx270, r270, fx90, r270, fx270, r90, fx270};
        int i = 0;
        AffineTransformType[] affineTransformTypeArray = trans;
        int n = trans.length;
        int n2 = 0;
        while (n2 < n) {
            AffineTransformType att = affineTransformTypeArray[n2];
            int x = locs[i][0] * genW;
            int y = locs[i][1] * genH;
            offsetList.add(new int[]{x, y});
            genList.add(new DiagonalZigzagGen(genW, genH, att));
            ++i;
            ++n2;
        }
        return new MultiGen(6 * genW, 4 * genH, offsetList, genList);
    }
}

