/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.MultiGen;
import net.paulhertz.pixelaudio.PixelMapGen;

public class HilbertGen
extends PixelMapGen {
    public int depth;
    private boolean doXYSwap;
    public static final String description = "HilbertGen generates a Hilbert curve over a square bitmap starting at (0,0) and ending at (width-1, 0). \nWidth and height must be equal powers of 2. You can also call HilbertGen(int depth) and width and height will equal Math.pow(2, depth). ";

    public HilbertGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
        this.depth = PixelMapGen.findPowerOfTwo(this.w);
        this.doXYSwap = this.depth % 2 == 1;
        this.generate();
    }

    public HilbertGen(int width, int height) {
        super(width, height);
        this.depth = PixelMapGen.findPowerOfTwo(this.w);
        this.doXYSwap = this.depth % 2 == 1;
        this.generate();
    }

    public HilbertGen(int depth) {
        this((int)Math.round(Math.pow(2.0, depth)), (int)Math.round(Math.pow(2.0, depth)));
    }

    public HilbertGen(int depth, AffineTransformType type) {
        this((int)Math.round(Math.pow(2.0, depth)), (int)Math.round(Math.pow(2.0, depth)), type);
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        return HilbertGen.prevalidate(width, height);
    }

    public static boolean prevalidate(int width, int height) {
        if (width < 2) {
            System.out.println("HilbertGen Error: 2 is the minimum value for width and height, 1 is the minimum value for depth.");
            return false;
        }
        if (width != height) {
            System.out.println("HilbertGen Error: Width and height must be equal.");
            return false;
        }
        if (!PixelMapGen.isPowerOfTwo(width)) {
            System.out.println("HilbertGen Error: Width and height must be equal to a power of 2.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateHilbertCoordinates(this.getSize());
    }

    private ArrayList<int[]> generateHilbertCoordinates(int n) {
        ArrayList<int[]> coordinates = new ArrayList<int[]>(n);
        if (n == 4) {
            coordinates.add(new int[2]);
            int[] nArray = new int[2];
            nArray[1] = 1;
            coordinates.add(nArray);
            coordinates.add(new int[]{1, 1});
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            coordinates.add(nArray2);
        } else {
            int i = 0;
            while (i < n) {
                int[] xy = this.d2xy(n, i);
                coordinates.add(xy);
                ++i;
            }
        }
        return coordinates;
    }

    private int[] d2xy(int n, int pos) {
        int temp;
        int rx = 0;
        int ry = 0;
        int s = 0;
        int t = pos;
        int bertx = 0;
        int berty = 0;
        s = 1;
        while (s < n) {
            rx = 1 & t / 2;
            ry = 1 & (t ^ rx);
            if (ry == 0) {
                if (rx == 1) {
                    bertx = s - 1 - bertx;
                    berty = s - 1 - berty;
                }
                temp = berty;
                berty = bertx;
                bertx = temp;
            }
            bertx += s * rx;
            berty += s * ry;
            t /= 4;
            s *= 2;
        }
        if (this.doXYSwap) {
            temp = berty;
            berty = bertx;
            bertx = temp;
        }
        return new int[]{bertx, berty};
    }

    public static MultiGen hilbertMultigenLoop(int columns, int rows, int genEdge) {
        if (columns == 1 || rows == 1) {
            columns *= 2;
            rows *= 2;
            genEdge /= 2;
        }
        if (columns % 2 == 1 && rows % 2 == 1) {
            columns *= 2;
            rows *= 2;
            genEdge /= 2;
        }
        if (!HilbertGen.prevalidate(genEdge, genEdge)) {
            return null;
        }
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int y = 0;
        int x = 0;
        if (columns % 2 == 0) {
            x = 0;
            while (x < columns) {
                genList.add(new HilbertGen(genEdge, genEdge, flipy));
                offsetList.add(new int[]{x * genEdge, y * genEdge});
                ++x;
            }
            ++y;
            if (rows == 2) {
                x = columns - 1;
                while (x >= 0) {
                    genList.add(new HilbertGen(genEdge, genEdge, flipx));
                    offsetList.add(new int[]{x * genEdge, y * genEdge});
                    --x;
                }
            } else {
                x = columns - 1;
                while (x >= 0) {
                    if (x % 2 == 1) {
                        y = 1;
                        while (y < rows - 1) {
                            genList.add(new HilbertGen(genEdge, genEdge, r270));
                            offsetList.add(new int[]{x * genEdge, y * genEdge});
                            ++y;
                        }
                        genList.add(new HilbertGen(genEdge, genEdge, flipx));
                        offsetList.add(new int[]{x * genEdge, y * genEdge});
                    } else {
                        y = rows - 1;
                        genList.add(new HilbertGen(genEdge, genEdge, flipx));
                        offsetList.add(new int[]{x * genEdge, y * genEdge});
                        y = rows - 2;
                        while (y > 0) {
                            genList.add(new HilbertGen(genEdge, genEdge, r90));
                            offsetList.add(new int[]{x * genEdge, y * genEdge});
                            --y;
                        }
                    }
                    --x;
                }
            }
        } else {
            y = 0;
            while (y < rows) {
                genList.add(new HilbertGen(genEdge, genEdge, r270));
                offsetList.add(new int[]{x * genEdge, y * genEdge});
                ++y;
            }
            ++x;
            if (columns == 2) {
                y = rows - 1;
                while (y >= 0) {
                    genList.add(new HilbertGen(genEdge, genEdge, flipy));
                    offsetList.add(new int[]{x * genEdge, y * genEdge});
                    --y;
                }
            } else {
                y = rows - 1;
                while (y >= 0) {
                    if (y % 2 == 1) {
                        x = 1;
                        while (x < columns - 1) {
                            genList.add(new HilbertGen(genEdge, genEdge, flipy));
                            offsetList.add(new int[]{x * genEdge, y * genEdge});
                            ++x;
                        }
                        genList.add(new HilbertGen(genEdge, genEdge, r90));
                        offsetList.add(new int[]{x * genEdge, y * genEdge});
                    } else {
                        x = columns - 1;
                        genList.add(new HilbertGen(genEdge, genEdge, r90));
                        offsetList.add(new int[]{x * genEdge, y * genEdge});
                        x = columns - 2;
                        while (x > 0) {
                            genList.add(new HilbertGen(genEdge, genEdge, flipx));
                            offsetList.add(new int[]{x * genEdge, y * genEdge});
                            --x;
                        }
                    }
                    --y;
                }
            }
        }
        return new MultiGen(columns * genEdge, rows * genEdge, offsetList, genList);
    }

    public static MultiGen hilbertLoop3x2(int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        genList.add(new HilbertGen(genW, genH, fx270));
        offsetList.add(new int[2]);
        genList.add(new HilbertGen(genW, genH, nada));
        int[] nArray = new int[2];
        nArray[0] = genW;
        offsetList.add(nArray);
        genList.add(new HilbertGen(genW, genH, fx90));
        int[] nArray2 = new int[2];
        nArray2[0] = 2 * genW;
        offsetList.add(nArray2);
        genList.add(new HilbertGen(genW, genH, fx90));
        offsetList.add(new int[]{2 * genW, genH});
        genList.add(new HilbertGen(genW, genH, r180));
        offsetList.add(new int[]{genW, genH});
        genList.add(new HilbertGen(genW, genH, fx270));
        int[] nArray3 = new int[2];
        nArray3[1] = genH;
        offsetList.add(nArray3);
        return new MultiGen(3 * genW, 2 * genH, offsetList, genList);
    }

    public static MultiGen hilbertVerticalStackOrtho(int stacks, int rows, int units, int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int s = 0;
        while (s < stacks) {
            int r = 0;
            while (r < rows) {
                int shift = s * units;
                int u = 0;
                while (u < units) {
                    genList.add(new HilbertGen(genW, genH));
                    offsetList.add(new int[]{(u + shift) * genW, r * genH});
                    ++u;
                }
                ++r;
            }
            ++s;
        }
        return new MultiGen(stacks * units * genW, rows * genH, offsetList, genList);
    }

    public static MultiGen hilbertVerticalStackBou(int stacks, int rows, int units, int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int s = 0;
        while (s < stacks) {
            int r = 0;
            while (r < rows) {
                int shift = s * units;
                if (r % 2 == 1) {
                    u = 0;
                    while (u < units) {
                        genList.add(new HilbertGen(genW, genH, flipx));
                        offsetList.add(new int[]{(u + shift) * genW, r * genH});
                        ++u;
                    }
                } else {
                    u = units;
                    while (u > 0) {
                        genList.add(new HilbertGen(genW, genH, flipy));
                        offsetList.add(new int[]{(u + shift - 1) * genW, r * genH});
                        --u;
                    }
                }
                ++r;
            }
            ++s;
        }
        return new MultiGen(stacks * units * genW, rows * genH, offsetList, genList);
    }
}

