/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import java.util.HashMap;

public class Lindenmayer {
    private HashMap<String, String> transTable = new HashMap();
    public boolean verbose = false;

    public String get(String clef) {
        if (this.transTable.containsKey(clef)) {
            return this.transTable.get(clef);
        }
        return clef;
    }

    public void put(String clef, String value) {
        this.transTable.put(clef, value);
    }

    public void expandString(ArrayList<String> tokens, int levels, ArrayList<String> sb) {
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < tokens.size()) {
            String ch = tokens.get(i);
            String val = this.get(ch);
            int j = 0;
            while (j < val.length()) {
                temp.add("" + val.charAt(j));
                ++j;
            }
            ++i;
        }
        if (levels > 0) {
            this.expandString(temp, levels - 1, sb);
        } else {
            int j = 0;
            while (j < tokens.size()) {
                sb.add(tokens.get(j));
                ++j;
            }
        }
    }

    public ArrayList<String> hilbert(int depth) {
        Lindenmayer lind = new Lindenmayer();
        lind.put("L", "+RF-LFL-FR+");
        lind.put("R", "-LF+RFR+FL-");
        ArrayList<String> buf = new ArrayList<String>();
        ArrayList<String> seed = new ArrayList<String>();
        seed.add("L");
        lind.expandString(seed, depth, buf);
        if (this.verbose) {
            System.out.println("Hilbert L-system at depth " + depth + "\n");
            for (String element : buf) {
                System.out.print(element);
            }
        }
        return buf;
    }

    public int[] loadAnimSteps(AnimStepper stepper) {
        for (AnimUnit animUnit : stepper.getList()) {
        }
        return null;
    }

    public class AnimStepper {
        public ArrayList<AnimUnit> stepList = new ArrayList();
        AnimUnit currentUnit;
        int u = 0;
        int t = 0;

        public AnimStepper() {
        }

        public AnimStepper(AnimUnit au) {
            this();
            this.addUnit(au);
        }

        public void addUnit(AnimUnit au) {
            this.stepList.add(au);
        }

        public int totalSlide() {
            int slide = 0;
            for (AnimUnit element : this.stepList) {
                slide += element.slide();
            }
            return slide;
        }

        public int totalSteps() {
            int steps = 0;
            for (AnimUnit element : this.stepList) {
                steps += element.getCount();
            }
            return steps;
        }

        public int totalFrames() {
            int frames = 0;
            for (AnimUnit element : this.stepList) {
                frames += element.frames();
            }
            return frames;
        }

        public int[] getStepArray() {
            int[] stepArray = new int[this.totalSteps()];
            for (AnimUnit animUnit : this.stepList) {
            }
            return stepArray;
        }

        public void reset() {
            this.u = 0;
            this.t = 0;
        }

        public ArrayList<AnimUnit> getList() {
            return this.stepList;
        }
    }

    public class AnimUnit {
        int d = 1;
        int n = 1;
        float s = 1.0f;

        public AnimUnit(int duration, int count) {
            this.d = duration;
            this.n = count;
        }

        public AnimUnit(int duration, int count, float stepSize) {
            this.d = duration;
            this.n = count;
            this.s = stepSize;
        }

        public int getDuration() {
            return this.d;
        }

        public void setDuration(int d) {
            this.d = d;
        }

        public int getCount() {
            return this.n;
        }

        public void setCount(int n) {
            this.n = n;
        }

        public float getStepSize() {
            return this.s;
        }

        public void setStepSize(float s) {
            this.s = s;
        }

        public int frames() {
            return this.d * this.n;
        }

        public int slide() {
            return Math.round(this.s * (float)this.frames());
        }

        public int[] toArray() {
            int[] arr = new int[this.n];
            int i = 0;
            while (i < this.n) {
                arr[i] = this.d;
                ++i;
            }
            return arr;
        }
    }
}

