/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.HilbertGen;
import net.paulhertz.pixelaudio.PixelMapGen;

public class MooreGen
extends PixelMapGen {
    public int depth;
    public static final String description = "MooreGen generates a Moore curve over a square bitmap starting at (width/2 - 1, 0) and ending at (width/2, 0). \nWidth and height must be equal powers of 2. You can also call MooreGen(int depth) and width and height will equal Math.pow(2, depth). ";

    public MooreGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
        this.depth = PixelMapGen.findPowerOfTwo(this.w);
        this.generate();
    }

    public MooreGen(int width, int height) {
        this(width, height, AffineTransformType.NADA);
    }

    public MooreGen(int depth) {
        this((int)Math.round(Math.pow(2.0, depth)), (int)Math.round(Math.pow(2.0, depth)), AffineTransformType.NADA);
    }

    public MooreGen(int depth, AffineTransformType type) {
        this((int)Math.round(Math.pow(2.0, depth)), (int)Math.round(Math.pow(2.0, depth)), type);
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width < 2) {
            System.out.println("MooreGen Error: 2 is the minimum value for width and height, 1 is the minimum value for depth.");
            return false;
        }
        if (width != height) {
            System.out.println("MooreGen Error: Width and height must be equal.");
            return false;
        }
        if (!PixelMapGen.isPowerOfTwo(width)) {
            System.out.println("MooreGen Error: Width and height must be equal to a power of 2.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateMooreCoordinates(this.getSize());
    }

    private ArrayList<int[]> generateMooreCoordinates(int n) {
        ArrayList<int[]> mooreCoordinates = new ArrayList<int[]>(n);
        if (n == 4) {
            mooreCoordinates.add(new int[2]);
            int[] nArray = new int[2];
            nArray[1] = 1;
            mooreCoordinates.add(nArray);
            mooreCoordinates.add(new int[]{1, 1});
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            mooreCoordinates.add(nArray2);
            System.out.println("-- Moore n == 4");
        } else {
            int hilbDepth = this.depth - 1;
            HilbertGen hilb = new HilbertGen(hilbDepth);
            int[] xcoords = new int[hilb.size];
            int[] ycoords = new int[hilb.size];
            int i = 0;
            for (int[] xy : hilb.getCoordinates()) {
                xcoords[i] = xy[1];
                ycoords[i] = xy[0];
                ++i;
            }
            int m = hilb.getWidth() - 1;
            i = 0;
            while (i < xcoords.length) {
                xcoords[i] = m - xcoords[i];
                ++i;
            }
            i = 0;
            while (i < hilb.size) {
                mooreCoordinates.add(new int[]{xcoords[i], ycoords[i]});
                ++i;
            }
            i = 0;
            while (i < hilb.size) {
                mooreCoordinates.add(new int[]{xcoords[i], ycoords[i] + hilb.w});
                ++i;
            }
            i = 0;
            while (i < xcoords.length) {
                xcoords[i] = m - xcoords[i];
                ++i;
            }
            i = 0;
            while (i < ycoords.length) {
                ycoords[i] = m - ycoords[i];
                ++i;
            }
            i = 0;
            while (i < hilb.size) {
                mooreCoordinates.add(new int[]{xcoords[i] + hilb.w, ycoords[i] + hilb.w});
                ++i;
            }
            i = 0;
            while (i < hilb.size) {
                mooreCoordinates.add(new int[]{xcoords[i] + hilb.w, ycoords[i]});
                ++i;
            }
        }
        return mooreCoordinates;
    }
}

