/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.DiagonalZigzagGen;
import net.paulhertz.pixelaudio.HilbertGen;
import net.paulhertz.pixelaudio.PixelMapGen;

public class MultiGen
extends PixelMapGen {
    public int rows = 0;
    public int columns = 0;
    public ArrayList<PixelMapGen> genList;
    public ArrayList<int[]> offsetList = null;
    public static final String description = "MultiGen is a PixelMapGen that creates a single signal path over multiple PixelMapGens.";

    public MultiGen(int width, int height, AffineTransformType transform) {
        super(width, height, transform);
        boolean isTall;
        this.genList = new ArrayList();
        this.offsetList = new ArrayList();
        int halfway = 0;
        boolean bl = isTall = width < height;
        if (isTall) {
            halfway = height / 2;
            this.genList.add(new DiagonalZigzagGen(width, halfway));
            this.offsetList.add(new int[2]);
            this.genList.add(new DiagonalZigzagGen(width, height - halfway));
            int[] nArray = new int[2];
            nArray[1] = halfway;
            this.offsetList.add(nArray);
        } else {
            halfway = width / 2;
            this.genList.add(new DiagonalZigzagGen(halfway, height));
            this.offsetList.add(new int[2]);
            this.genList.add(new DiagonalZigzagGen(width - halfway, height));
            int[] nArray = new int[2];
            nArray[0] = halfway;
            this.offsetList.add(nArray);
        }
        this.generate();
    }

    public MultiGen(int width, int height) {
        this(width, height, AffineTransformType.NADA);
    }

    public MultiGen(int width, int height, int rows, int columns, ArrayList<PixelMapGen> genList) {
        super(width, height);
        this.rows = rows;
        this.columns = columns;
        this.genList = genList;
        this.generate();
    }

    public MultiGen(int width, int height, ArrayList<int[]> offsetList, ArrayList<PixelMapGen> genList) {
        super(width, height);
        this.genList = genList;
        this.offsetList = offsetList;
        this.generate();
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width >= 4 && height >= 4) {
            return true;
        }
        System.out.println("Width and height of MultiGen must equal to or greater than 4.");
        return false;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateMultiCoordinates(this.w, this.h);
    }

    private ArrayList<int[]> generateMultiCoordinates(int width, int height) {
        ArrayList<int[]> coordinates = new ArrayList<int[]>(width * height);
        if (this.offsetList != null) {
            int i = 0;
            for (int[] xy : this.offsetList) {
                int tx = xy[0];
                int ty = xy[1];
                ArrayList<int[]> genCoords = this.genList.get(i++).getCoordinates();
                genCoords = this.translateCoords(genCoords, tx, ty);
                coordinates.addAll(genCoords);
            }
        } else {
            int tx = width / this.rows;
            int ty = height / this.columns;
            int i = 0;
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    ArrayList<int[]> genCoords = this.genList.get(i++).getCoordinates();
                    genCoords = this.translateCoords(genCoords, r * tx, c * ty);
                    coordinates.addAll(genCoords);
                    ++r;
                }
                ++c;
            }
        }
        return coordinates;
    }

    public ArrayList<int[]> translateCoords(ArrayList<int[]> coordList, int tx, int ty) {
        ArrayList<int[]> newList = new ArrayList<int[]>(coordList.size());
        for (int[] xy : coordList) {
            newList.add(new int[]{xy[0] + tx, xy[1] + ty});
        }
        return newList;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public ArrayList<PixelMapGen> getGenList() {
        return this.genList;
    }

    public ArrayList<int[]> getOffsetList() {
        return this.offsetList;
    }

    public static MultiGen hilbertZigzagLoop6x4(int genW, int genH) {
        ArrayList<PixelMapGen> genList = new ArrayList<PixelMapGen>();
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        int[][] nArrayArray = new int[24][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 3;
        nArrayArray[3] = nArray3;
        nArrayArray[4] = new int[]{1, 3};
        nArrayArray[5] = new int[]{1, 2};
        nArrayArray[6] = new int[]{2, 2};
        nArrayArray[7] = new int[]{2, 3};
        nArrayArray[8] = new int[]{3, 3};
        nArrayArray[9] = new int[]{3, 2};
        nArrayArray[10] = new int[]{4, 2};
        nArrayArray[11] = new int[]{4, 3};
        nArrayArray[12] = new int[]{5, 3};
        nArrayArray[13] = new int[]{5, 2};
        nArrayArray[14] = new int[]{5, 1};
        int[] nArray4 = new int[2];
        nArray4[0] = 5;
        nArrayArray[15] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[0] = 4;
        nArrayArray[16] = nArray5;
        nArrayArray[17] = new int[]{4, 1};
        nArrayArray[18] = new int[]{3, 1};
        int[] nArray6 = new int[2];
        nArray6[0] = 3;
        nArrayArray[19] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[0] = 2;
        nArrayArray[20] = nArray7;
        nArrayArray[21] = new int[]{2, 1};
        nArrayArray[22] = new int[]{1, 1};
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        nArrayArray[23] = nArray8;
        int[][] locs = nArrayArray;
        AffineTransformType[] trans = new AffineTransformType[]{r270, r270, nada, r270, r90, fx270, nada, r270, r90, r90, fx90, nada, r90, r90, r180, r90, r270, fx90, r180, r90, r270, r270, fx270, r180};
        char[] cues = new char[]{'H', 'D', 'D', 'H', 'D', 'H', 'D', 'H', 'H', 'D', 'H', 'D', 'H', 'D', 'D', 'H', 'D', 'H', 'D', 'H', 'H', 'D', 'H', 'D'};
        int i = 0;
        AffineTransformType[] affineTransformTypeArray = trans;
        int n = trans.length;
        int n2 = 0;
        while (n2 < n) {
            AffineTransformType att = affineTransformTypeArray[n2];
            int x = locs[i][0] * genW;
            int y = locs[i][1] * genH;
            offsetList.add(new int[]{x, y});
            if (cues[i] == 'H') {
                genList.add(new HilbertGen(genW, genH, att));
            } else {
                genList.add(new DiagonalZigzagGen(genW, genH, att));
            }
            ++i;
            ++n2;
        }
        return new MultiGen(6 * genW, 4 * genH, offsetList, genList);
    }
}

