/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import processing.core.PApplet;

public class PixelAudio {
    public static PApplet myParent;
    private static Random rando;
    public static final String VERSION = "0.9.4-beta";
    public static final int SR_96k = 96000;
    public static final int SR_48k = 48000;
    public static final int SR_44dot1k = 44100;
    public static final int SR_256x256 = 65536;
    public static final int SR_512x512 = 262144;
    public static final int SR_1024x1024 = 0x100000;

    public PixelAudio(PApplet pApplet) {
        myParent = pApplet;
        this.welcome();
    }

    private void welcome() {
        System.out.println("PixelAudio 0.9.4-beta by Paul Hertz https://paulhertz.net/");
    }

    public String sayHello() {
        return "Hello from PixelAudio.";
    }

    public static String version() {
        return VERSION;
    }

    public static final float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static final int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final float map(float f, float f2, float f3, float f4, float f5) {
        return f4 + (f5 - f4) * ((f - f2) / (f3 - f2));
    }

    public static final float lerp(float f, float f2, float f3) {
        return f + f3 * (f2 - f);
    }

    public static double gauss(double d, double d2) {
        return PixelAudio.rando().nextGaussian() * Math.sqrt(d2) + d;
    }

    public static Random rando() {
        if (rando == null) {
            rando = new Random();
        }
        return rando;
    }

    public static Random rando(long l) {
        rando = new Random(l);
        return rando;
    }

    public static void saveAudioToFile(float[] fArray, float f, String string) throws IOException, UnsupportedAudioFileException {
        byte[] byArray = new byte[fArray.length * 2];
        int n = 0;
        for (float file : fArray) {
            int n2 = (int)(file * 32767.0f);
            byArray[n++] = (byte)(n2 & 0xFF);
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioFormat audioFormat = new AudioFormat(f, 16, 1, true, false);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, fArray.length);
        File file = new File(string);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
    }

    public static void saveAudioTo32BitPCMFile(float[] fArray, float f, String string) throws IOException {
        byte[] byArray = new byte[fArray.length * 4];
        int n = 0;
        for (float file : fArray) {
            int n2 = Float.floatToIntBits(file);
            byArray[n++] = (byte)(n2 & 0xFF);
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n++] = (byte)(n2 >> 16 & 0xFF);
            byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioFormat audioFormat = new AudioFormat(f, 32, 1, true, false);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, fArray.length);
        File file = new File(string);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
    }

    public static void saveStereoAudioToFile(float[] fArray, float[] fArray2, float f, String string) throws IOException, UnsupportedAudioFileException {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Left and right channel sample arrays must have the same length.");
        }
        int n = fArray.length;
        byte[] byArray = new byte[fArray.length * 2 * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)(fArray[i] * 32767.0f);
            int n4 = (int)(fArray2[i] * 32767.0f);
            byArray[n2++] = (byte)(n3 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
            byArray[n2++] = (byte)(n4 & 0xFF);
            byArray[n2++] = (byte)(n4 >> 8 & 0xFF);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioFormat audioFormat = new AudioFormat(f, 16, 2, true, false);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, n);
        File file = new File(string);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
    }

    public static void saveStereoAudioTo32BitPCMFile(float[] fArray, float[] fArray2, float f, String string) throws IOException {
        int n = fArray.length;
        byte[] byArray = new byte[n * 2 * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = Float.floatToIntBits(fArray[i]);
            byArray[n2++] = (byte)(n3 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
            n3 = Float.floatToIntBits(fArray2[i]);
            byArray[n2++] = (byte)(n3 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
            byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioFormat audioFormat = new AudioFormat(f, 32, 2, true, false);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, n);
        File file = new File(string);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
    }
}

