/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.paulhertz.pixelaudio.PixelMapGen;

public class PixelAudioMapper {
    protected int width;
    protected int height;
    protected int mapSize;
    protected int[] signalToImageLUT;
    protected int[] imageToSignalLUT;
    protected PixelMapGen generator;

    public PixelAudioMapper(PixelMapGen gen) {
        this.setGenerator(gen);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.mapSize;
    }

    public String toString() {
        return "Parent class for PixelAudioMapper objects, please see the documentation in its comments.";
    }

    public int[] getSignalToImageLUT() {
        return this.signalToImageLUT;
    }

    protected void setSignalToImageLUT(int[] sigLUT) {
        if (sigLUT.length != this.signalToImageLUT.length) {
            throw new IllegalArgumentException("The new signalToImageLUT array must be the same size as the old signalToImageLUT array.");
        }
        this.signalToImageLUT = sigLUT;
    }

    public int[] getImageToSignalLUT() {
        return this.imageToSignalLUT;
    }

    protected void setImageToSignalLUT(int[] imgLUT) {
        if (imgLUT.length != this.imageToSignalLUT.length) {
            throw new IllegalArgumentException("The new imageToSignalLUT array must be the same size as the old imageToSignalLUT array.");
        }
        this.imageToSignalLUT = imgLUT;
    }

    public ArrayList<int[]> getGeneratorCoordinatesCopy() {
        return this.generator.getCoordinatesCopy();
    }

    public String getGeneratorDescription() {
        return this.generator.describe();
    }

    public PixelMapGen getGenerator() {
        return this.generator;
    }

    public void setGenerator(PixelMapGen newGen) {
        this.generator = newGen;
        this.regenerate();
    }

    public void regenerate() {
        this.width = this.generator.getWidth();
        this.height = this.generator.getHeight();
        this.mapSize = this.generator.getSize();
        this.signalToImageLUT = this.generator.getPixelMapCopy();
        this.imageToSignalLUT = this.generator.getSampleMapCopy();
    }

    public int[] getInverseArray(int[] src) {
        int[] dest = new int[src.length];
        int i = 0;
        while (i < this.width * this.height - 1) {
            dest[src[i]] = i;
            ++i;
        }
        return dest;
    }

    public static int audioToRGBChan(float val) {
        return (int)(127.5f * (val + 1.0f) + 0.5f);
    }

    public static float rgbChanToAudio(int val) {
        return (float)val / 127.5f - 1.0f;
    }

    public static float rgbFloatToAudio(float val) {
        return val / 127.5f - 1.0f;
    }

    public static float hsbFloatToAudio(float val) {
        return 2.0f * val - 1.0f;
    }

    public static float audioToHSBFloat(float val) {
        return (val + 1.0f) / 2.0f;
    }

    public int lookupSample(int x, int y) {
        return this.imageToSignalLUT[x + y * this.width];
    }

    public int lookupSample(int imagePos) {
        return this.imageToSignalLUT[imagePos];
    }

    public int lookupPixel(int signalPos) {
        return this.signalToImageLUT[signalPos];
    }

    public int[] lookupCoordinate(int signalPos) {
        int imagePos = this.signalToImageLUT[signalPos];
        int x = imagePos % this.width;
        int y = imagePos / this.width;
        return new int[]{x, y};
    }

    public static int[] remapPixels(int[] img, int[] lut) {
        if (img.length != lut.length) {
            throw new IllegalArgumentException("img and lut arrays must be the same size");
        }
        int[] newPixels = new int[img.length];
        int i = 0;
        while (i < img.length) {
            newPixels[i] = img[lut[i]];
            ++i;
        }
        return newPixels;
    }

    public static float[] remapSamples(float[] sig, int[] lut) {
        if (sig.length != lut.length) {
            throw new IllegalArgumentException("sig and lut arrays must be the same size");
        }
        float[] newSignal = new float[sig.length];
        int i = 0;
        while (i < sig.length) {
            newSignal[i] = sig[lut[i]];
            ++i;
        }
        return newSignal;
    }

    public int[] mapSigToImg(float[] sig, int[] img) {
        if (sig.length != img.length) {
            throw new IllegalArgumentException("sig and img arrays must be the same size");
        }
        return PixelAudioMapper.pushAudioToChannel(sig, img, this.signalToImageLUT, ChannelNames.ALL);
    }

    public int[] mapSigToImg(float[] sig, int[] img, ChannelNames toChannel) {
        if (sig.length != img.length) {
            throw new IllegalArgumentException("sig and img arrays must be the same size");
        }
        if (sig.length != this.getSize()) {
            throw new IllegalArgumentException("sig and img array lengths must equal mapper.getSize()");
        }
        return PixelAudioMapper.pushAudioToChannel(sig, img, this.signalToImageLUT, toChannel);
    }

    public float[] mapImgToSig(int[] img, float[] sig) {
        if (sig.length != img.length) {
            throw new IllegalArgumentException("sig and img arrays must be the same size");
        }
        if (sig.length != this.getSize()) {
            throw new IllegalArgumentException("sig and img array lengths must equal mapper.getSize()");
        }
        float[] hsbPixel = new float[3];
        return PixelAudioMapper.pullPixelAsAudio(img, sig, this.signalToImageLUT, ChannelNames.L, hsbPixel);
    }

    public float[] mapImgToSig(int[] img, float[] sig, ChannelNames fromChannel) {
        if (img.length != sig.length) {
            throw new IllegalArgumentException("img and sig arrays must be the same size");
        }
        float[] hsbPixel = new float[3];
        return PixelAudioMapper.pullPixelAsAudio(img, sig, this.signalToImageLUT, fromChannel, hsbPixel);
    }

    public void writeImgToSig(int[] img, float[] sig) {
        if (img.length != sig.length) {
            throw new IllegalArgumentException("img and sig arrays must be the same size");
        }
        float[] hsbPixel = new float[3];
        PixelAudioMapper.pullPixelAsAudio(img, sig, ChannelNames.ALL, hsbPixel);
    }

    public void writeImgToSig(int[] img, float[] sig, ChannelNames fromChannel) {
        if (img.length != sig.length) {
            throw new IllegalArgumentException("img and sig arrays must be the same size");
        }
        float[] hsbPixel = new float[3];
        PixelAudioMapper.pullPixelAsAudio(img, sig, fromChannel, hsbPixel);
    }

    public void writeSigToImg(float[] sig, int[] img) {
        if (sig.length != img.length) {
            throw new IllegalArgumentException("sig and img arrays must be the same size");
        }
        PixelAudioMapper.pushAudioToPixel(sig, img, ChannelNames.ALL);
    }

    public void writeSigToImg(float[] sig, int[] img, ChannelNames toChannel) {
        if (sig.length != img.length) {
            throw new IllegalArgumentException("sig and img arrays must be the same size");
        }
        PixelAudioMapper.pushAudioToPixel(sig, img, toChannel);
    }

    public int[] conformArray(int[] source) {
        if (source.length == this.mapSize) {
            return source;
        }
        source = Arrays.copyOf(source, this.mapSize);
        return source;
    }

    public float[] conformArray(float[] source) {
        if (source.length == this.mapSize) {
            return source;
        }
        source = Arrays.copyOf(source, this.mapSize);
        return source;
    }

    public static int[] conformArray(int[] source, int mapSize) {
        if (source.length == mapSize) {
            return source;
        }
        source = Arrays.copyOf(source, mapSize);
        return source;
    }

    public static float[] conformArray(float[] source, int mapSize) {
        if (source.length == mapSize) {
            return source;
        }
        source = Arrays.copyOf(source, mapSize);
        return source;
    }

    public int[] pluckPixels(int[] img, int signalPos, int length) {
        if (img == null) {
            throw new IllegalArgumentException("Image array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (signalPos < 0 || signalPos >= img.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > img.length) {
            throw new IllegalArgumentException("Invalid length");
        }
        int[] pixels = new int[length];
        int i = 0;
        while (i < length) {
            pixels[i] = img[this.signalToImageLUT[signalPos + i]];
            ++i;
        }
        return pixels;
    }

    public float[] pluckPixelsAsAudio(int[] img, int signalPos, int length, ChannelNames fromChannel) {
        if (img == null) {
            throw new IllegalArgumentException("img array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (signalPos < 0 || signalPos >= img.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > img.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        float[] samples = new float[length];
        float[] hsbPixel = new float[3];
        int j = 0;
        while (j < length) {
            int i = signalPos + j;
            int rgb = img[this.signalToImageLUT[i]];
            samples[j] = PixelAudioMapper.extractColorAsAudio(rgb, fromChannel, hsbPixel);
            ++j;
        }
        return samples;
    }

    public float[] pluckSamples(float[] sig, int signalPos, int length) {
        if (sig == null) {
            throw new IllegalArgumentException("sig array cannot be null");
        }
        if (signalPos < 0 || signalPos >= sig.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > sig.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        float[] samples = new float[this.mapSize];
        int j = 0;
        while (j < length) {
            samples[j] = sig[signalPos + j];
            ++j;
        }
        return samples;
    }

    public int[] pluckSamplesAsRGB(float[] sig, int signalPos, int length) {
        if (sig == null) {
            throw new IllegalArgumentException("sig array cannot be null");
        }
        if (signalPos < 0 || signalPos >= sig.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > sig.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        int[] rgbPixels = new int[length];
        int j = 0;
        int i = signalPos;
        while (i < signalPos + length) {
            float sample = sig[i];
            int v = PixelAudioMapper.audioToRGBChan(sample);
            rgbPixels[j++] = 0xFF000000 | v << 16 | v << 8 | v;
            ++i;
        }
        return rgbPixels;
    }

    public void plantPixels(int[] sprout, int[] img, int signalPos, int length) {
        if (sprout == null || img == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (signalPos < 0 || signalPos >= img.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > img.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        int j = 0;
        int i = signalPos;
        while (i < signalPos + length) {
            img[this.signalToImageLUT[i]] = sprout[j++];
            ++i;
        }
    }

    public void plantPixels(int[] sprout, int[] img, int signalPos, int length, ChannelNames toChannel) {
        if (sprout == null || img == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (signalPos < 0 || signalPos >= img.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > img.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        float[] hsbPixel = new float[3];
        int j = 0;
        while (j < length) {
            int imgIdx = this.signalToImageLUT[signalPos + j];
            img[imgIdx] = PixelAudioMapper.applyChannelToColor(sprout[j], img[imgIdx], toChannel, hsbPixel);
            ++j;
        }
    }

    public void plantPixels(float[] sprout, int[] img, int signalPos, int length, ChannelNames toChannel) {
        if (sprout == null || img == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (signalPos < 0 || signalPos >= img.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > img.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        float[] hsbPixel = new float[3];
        int j = 0;
        while (j < length) {
            int imgIdx = this.signalToImageLUT[signalPos + j];
            img[imgIdx] = PixelAudioMapper.applyAudioToColor(sprout[j], img[imgIdx], toChannel, hsbPixel);
            ++j;
        }
    }

    public void plantSamples(float[] sprout, float[] sig, int signalPos, int length) {
        if (sprout == null || sig == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (signalPos < 0 || signalPos >= sig.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > sig.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        int j = 0;
        int i = signalPos;
        while (i < signalPos + length) {
            sig[i] = sprout[j++];
            ++i;
        }
    }

    public void plantSamples(int[] sprout, float[] sig, int signalPos, int length) {
        if (sprout == null || sig == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (signalPos < 0 || signalPos >= sig.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > sig.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        int j = 0;
        int i = signalPos;
        while (i < signalPos + length) {
            sig[i] = PixelAudioMapper.rgbChanToAudio(PixelAudioMapper.getLuminosity(sprout[j++]));
            ++i;
        }
    }

    public void plantSamples(int[] sprout, float[] sig, int signalPos, int length, ChannelNames fromChannel) {
        if (sprout == null || sig == null) {
            throw new IllegalArgumentException("Input arrays cannot be null");
        }
        if (signalPos < 0 || signalPos >= sig.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > sig.length || length > sprout.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        float[] hsbPixel = new float[3];
        int j = 0;
        while (j < length) {
            sig[signalPos + j] = PixelAudioMapper.extractColorAsAudio(sprout[j], fromChannel, hsbPixel);
            ++j;
        }
    }

    public int[] peelPixels(int[] img, int x, int y, int w, int h) {
        if (img == null) {
            throw new IllegalArgumentException("img array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int[] rgbPixels = new int[w * h];
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                rgbPixels[j++] = img[rowStart + dx];
                ++dx;
            }
            ++dy;
        }
        return rgbPixels;
    }

    public float[] peelPixelsAsAudio(int[] img, int x, int y, int w, int h) {
        if (img == null) {
            throw new IllegalArgumentException("img array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        float[] samples = new float[w * h];
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                samples[j++] = PixelAudioMapper.rgbChanToAudio(PixelAudioMapper.getLuminosity(img[rowStart + dx]));
                ++dx;
            }
            ++dy;
        }
        return samples;
    }

    public float[] peelSamples(float[] sig, int x, int y, int w, int h) {
        if (sig == null) {
            throw new IllegalArgumentException("img array cannot be null");
        }
        if (sig.length != this.width * this.height) {
            throw new IllegalArgumentException("sig length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        float[] samples = new float[w * h];
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                samples[j++] = sig[this.imageToSignalLUT[rowStart + dx]];
                ++dx;
            }
            ++dy;
        }
        return samples;
    }

    public int[] peelSamplesAsRGB(float[] sig, int x, int y, int w, int h) {
        if (sig == null) {
            throw new IllegalArgumentException("img array cannot be null");
        }
        if (sig.length != this.width * this.height) {
            throw new IllegalArgumentException("sig length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int[] rgbPixels = new int[w * h];
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int dx = x;
            while (dx < x + w) {
                int rowStart = dy * this.width;
                rgbPixels[j++] = Math.round(PixelAudioMapper.rgbFloatToAudio(sig[this.imageToSignalLUT[rowStart + dx]]));
                ++dx;
            }
            ++dy;
        }
        return rgbPixels;
    }

    public void stampPixels(int[] stamp, int[] img, int x, int y, int w, int h) {
        if (stamp == null) {
            throw new IllegalArgumentException("stamp array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                img[rowStart + dx] = stamp[j++];
                ++dx;
            }
            ++dy;
        }
    }

    public void stampPixels(int[] stamp, int[] img, int x, int y, int w, int h, ChannelNames toChannel) {
        if (stamp == null) {
            throw new IllegalArgumentException("stamp array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        float[] hsbPixel = new float[3];
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                img[rowStart + dx] = PixelAudioMapper.applyChannelToColor(stamp[j++], img[rowStart + dx], toChannel, hsbPixel);
                ++dx;
            }
            ++dy;
        }
    }

    public void stampPixels(float[] stamp, int[] img, int x, int y, int w, int h, ChannelNames toChannel) {
        if (stamp == null) {
            throw new IllegalArgumentException("stamp array cannot be null");
        }
        if (img.length != this.width * this.height) {
            throw new IllegalArgumentException("img length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int j = 0;
        float[] hsbPixel = new float[3];
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                img[rowStart + dx] = PixelAudioMapper.applyAudioToColor(stamp[j++], img[rowStart + dx], toChannel, hsbPixel);
                ++dx;
            }
            ++dy;
        }
    }

    public void stampSamples(float[] stamp, float[] sig, int x, int y, int w, int h) {
        if (stamp == null) {
            throw new IllegalArgumentException("stamp array cannot be null");
        }
        if (sig.length != this.width * this.height) {
            throw new IllegalArgumentException("sig length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                sig[this.imageToSignalLUT[rowStart + dx]] = stamp[j++];
                ++dx;
            }
            ++dy;
        }
    }

    public void stampSamples(int[] stamp, float[] sig, int x, int y, int w, int h) {
        if (stamp == null) {
            throw new IllegalArgumentException("stamp array cannot be null");
        }
        if (sig.length != this.width * this.height) {
            throw new IllegalArgumentException("sig length does not match PixelAudioMapper dimensions");
        }
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new IllegalArgumentException("Requested rectangle is out of image bounds");
        }
        int j = 0;
        int dy = y;
        while (dy < y + h) {
            int rowStart = dy * this.width;
            int dx = x;
            while (dx < x + w) {
                sig[this.imageToSignalLUT[rowStart + dx]] = PixelAudioMapper.rgbChanToAudio(stamp[j++]);
                ++dx;
            }
            ++dy;
        }
    }

    public static float extractColorAsAudio(int rgb, ChannelNames chan, float[] hsbPixel) {
        switch (chan) {
            case L: {
                return PixelAudioMapper.hsbFloatToAudio(PixelAudioMapper.brightness(rgb, hsbPixel));
            }
            case H: {
                return PixelAudioMapper.hsbFloatToAudio(PixelAudioMapper.hue(rgb, hsbPixel));
            }
            case S: {
                return PixelAudioMapper.hsbFloatToAudio(PixelAudioMapper.saturation(rgb, hsbPixel));
            }
            case R: {
                return PixelAudioMapper.rgbChanToAudio(rgb >> 16 & 0xFF);
            }
            case G: {
                return PixelAudioMapper.rgbChanToAudio(rgb >> 8 & 0xFF);
            }
            case B: {
                return PixelAudioMapper.rgbChanToAudio(rgb & 0xFF);
            }
            case A: {
                return PixelAudioMapper.rgbChanToAudio(rgb >> 24 & 0xFF);
            }
            case ALL: {
                return PixelAudioMapper.rgbFloatToAudio(0.3f * (float)(rgb >> 16 & 0xFF) + 0.59f * (float)(rgb >> 8 & 0xFF) + 0.11f * (float)(rgb & 0xFF));
            }
        }
        throw new AssertionError((Object)("Unknown channel: " + String.valueOf((Object)chan)));
    }

    public static int applyAudioToColor(float sample, int rgb, ChannelNames chan, float[] hsbPixel) {
        switch (chan) {
            case L: {
                return PixelAudioMapper.applyBrightness(sample, rgb, hsbPixel);
            }
            case H: {
                return PixelAudioMapper.applyHue(sample, rgb, hsbPixel);
            }
            case S: {
                return PixelAudioMapper.applySaturation(sample, rgb, hsbPixel);
            }
            case R: {
                return PixelAudioMapper.applyRed(sample, rgb);
            }
            case G: {
                return PixelAudioMapper.applyGreen(sample, rgb);
            }
            case B: {
                return PixelAudioMapper.applyBlue(sample, rgb);
            }
            case A: {
                return PixelAudioMapper.applyAlpha(sample, rgb);
            }
            case ALL: {
                return PixelAudioMapper.applyAll(sample, rgb);
            }
        }
        throw new AssertionError((Object)("Unknown channel: " + String.valueOf((Object)chan)));
    }

    public static int applyChannelToColor(int rgbSource, int rgbTarget, ChannelNames chan, float[] hsbPixel) {
        switch (chan) {
            case L: {
                return PixelAudioMapper.applyBrightness(rgbSource, rgbTarget, hsbPixel);
            }
            case H: {
                return PixelAudioMapper.applyHue(rgbSource, rgbTarget, hsbPixel);
            }
            case S: {
                return PixelAudioMapper.applySaturation(rgbSource, rgbTarget, hsbPixel);
            }
            case R: {
                return PixelAudioMapper.applyRed(rgbSource, rgbTarget);
            }
            case G: {
                return PixelAudioMapper.applyGreen(rgbSource, rgbTarget);
            }
            case B: {
                return PixelAudioMapper.applyBlue(rgbSource, rgbTarget);
            }
            case A: {
                return PixelAudioMapper.applyAlpha(rgbSource, rgbTarget);
            }
            case ALL: {
                return PixelAudioMapper.applyAll(rgbSource, rgbTarget);
            }
        }
        throw new AssertionError((Object)("Unknown channel: " + String.valueOf((Object)chan)));
    }

    public static float[] pullPixelAsAudio(int[] rgbPixels, float[] samples, ChannelNames chan, float[] hsbPixel) {
        if (samples == null || samples.length != rgbPixels.length) {
            samples = new float[rgbPixels.length];
        }
        int i = 0;
        while (i < samples.length) {
            samples[i] = PixelAudioMapper.extractColorAsAudio(rgbPixels[i], chan, hsbPixel);
            ++i;
        }
        return samples;
    }

    public static float[] pullPixelAsAudio(int[] rgbPixels, float[] samples, int[] lut, ChannelNames chan, float[] hsbPixel) {
        if (lut == null || lut.length != rgbPixels.length) {
            throw new IllegalArgumentException("Input array lut cannot be null and must be the same length as rgbPixels");
        }
        if (samples == null || samples.length != rgbPixels.length) {
            samples = new float[rgbPixels.length];
        }
        int i = 0;
        while (i < samples.length) {
            samples[i] = PixelAudioMapper.extractColorAsAudio(rgbPixels[lut[i]], chan, hsbPixel);
            ++i;
        }
        return samples;
    }

    public static int[] pullAudioAsColor(float[] samples, int[] rgbPixels, int signalPos, int length) {
        if (samples == null) {
            throw new IllegalArgumentException("samples array cannot be null");
        }
        if (rgbPixels == null || rgbPixels.length != samples.length) {
            rgbPixels = new int[samples.length];
        }
        if (signalPos < 0 || signalPos >= samples.length) {
            throw new IndexOutOfBoundsException("signalPos out of bounds");
        }
        if (length < 0 || signalPos + length > samples.length) {
            throw new IllegalArgumentException("Invalid length: out of bounds");
        }
        int j = 0;
        int i = signalPos;
        while (i < signalPos + length) {
            float sample = samples[i];
            sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
            int v = PixelAudioMapper.audioToRGBChan(sample);
            rgbPixels[j++] = 0xFF000000 | v << 16 | v << 8 | v;
            ++i;
        }
        return rgbPixels;
    }

    public static int[] pullAudioAsColor(float[] sig) {
        return PixelAudioMapper.pullAudioAsColor(sig, null, 0, sig.length);
    }

    public static int[] pushAudioToPixel(float[] samples, int[] rgbPixels, ChannelNames chan) {
        if (rgbPixels == null || rgbPixels.length != samples.length) {
            rgbPixels = new int[samples.length];
            Arrays.fill(rgbPixels, PixelAudioMapper.composeColor(127, 127, 127));
        }
        float[] hsbPixel = new float[3];
        int i = 0;
        while (i < rgbPixels.length) {
            rgbPixels[i] = PixelAudioMapper.applyAudioToColor(samples[i], rgbPixels[i], chan, hsbPixel);
            ++i;
        }
        return rgbPixels;
    }

    public static int[] pushAudioToChannel(float[] samples, int[] rgbPixels, int[] lut, ChannelNames chan) {
        if (lut == null || lut.length != samples.length) {
            throw new IllegalArgumentException("Input array lut cannot be null and must be the same length as signal.");
        }
        if (rgbPixels == null || rgbPixels.length != samples.length) {
            rgbPixels = new int[samples.length];
            Arrays.fill(rgbPixels, PixelAudioMapper.composeColor(127, 127, 127));
        }
        float[] hsbPixel = new float[3];
        int i = 0;
        while (i < rgbPixels.length) {
            rgbPixels[lut[i]] = PixelAudioMapper.applyAudioToColor(samples[i], rgbPixels[lut[i]], chan, hsbPixel);
            ++i;
        }
        return rgbPixels;
    }

    public static int[] pushChannelToPixel(int[] colors, int[] rgbPixels, ChannelNames chan) {
        if (rgbPixels == null || rgbPixels.length != colors.length) {
            rgbPixels = new int[colors.length];
            Arrays.fill(rgbPixels, PixelAudioMapper.composeColor(127, 127, 127));
        }
        float[] hsbPixel = new float[3];
        int i = 0;
        while (i < rgbPixels.length) {
            rgbPixels[i] = PixelAudioMapper.applyChannelToColor(colors[i], rgbPixels[i], chan, hsbPixel);
            ++i;
        }
        return rgbPixels;
    }

    public static int[] pushChannelToPixel(int[] colors, int[] rgbPixels, int[] lut, ChannelNames chan) {
        if (lut == null || lut.length != colors.length) {
            throw new IllegalArgumentException("Input array lut cannot be null and must be the same length as colors");
        }
        if (rgbPixels == null || rgbPixels.length != colors.length) {
            rgbPixels = new int[colors.length];
            Arrays.fill(rgbPixels, PixelAudioMapper.composeColor(127, 127, 127));
        }
        float[] hsbPixel = new float[3];
        int i = 0;
        while (i < rgbPixels.length) {
            rgbPixels[lut[i]] = PixelAudioMapper.applyChannelToColor(colors[i], rgbPixels[lut[i]], chan, hsbPixel);
            ++i;
        }
        return rgbPixels;
    }

    public static final void rotateLeft(int[] arr, int d) {
        int len = arr.length;
        if (d < 0) {
            d = len - -d % len;
        }
        PixelAudioMapper.reverseArray(arr, 0, (d %= len) - 1);
        PixelAudioMapper.reverseArray(arr, d, len - 1);
        PixelAudioMapper.reverseArray(arr, 0, len - 1);
    }

    public static final void rotateRight(int[] arr, int d) {
        PixelAudioMapper.rotateLeft(arr, -d);
    }

    public static final void rotateLeft(float[] arr, int d) {
        int len = arr.length;
        if (d < 0) {
            d = len - -d % len;
        }
        PixelAudioMapper.reverseArray(arr, 0, (d %= len) - 1);
        PixelAudioMapper.reverseArray(arr, d, len - 1);
        PixelAudioMapper.reverseArray(arr, 0, len - 1);
    }

    public static final void rotateRight(float[] arr, int d) {
        PixelAudioMapper.rotateLeft(arr, -d);
    }

    public static final void reverseArray(int[] arr, int l, int r) {
        while (l < r) {
            int temp = arr[l];
            arr[l] = arr[r];
            arr[r] = temp;
            ++l;
            --r;
        }
    }

    public static final void reverseArray(float[] arr, int l, int r) {
        while (l < r) {
            float temp = arr[l];
            arr[l] = arr[r];
            arr[r] = temp;
            ++l;
            --r;
        }
    }

    public static final int[] rgbComponents(int rgb) {
        int[] comp = new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF};
        return comp;
    }

    public static final int[] rgbaComponents(int argb) {
        int[] comp = new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF};
        return comp;
    }

    public static final int[] argbComponents(int argb) {
        int[] comp = new int[]{argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
        return comp;
    }

    public static final int alphaComponent(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static final int applyAlpha(int rgba, int rgb) {
        return rgba >> 24 << 24 | (rgb >> 16 & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb & 0xFF;
    }

    public static final int setAlpha(int argb, int alpha) {
        return argb & 0xFFFFFF | alpha << 24;
    }

    public static final int[] setAlpha(int[] argb, int alpha) {
        int i = 0;
        while (i < argb.length) {
            argb[i] = argb[i] & 0xFFFFFF | alpha << 24;
            ++i;
        }
        return argb;
    }

    public static final int composeColor(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static final int composeColor(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static final int composeColor(int[] comp) {
        return 0xFF000000 | comp[0] << 16 | comp[1] << 8 | comp[2];
    }

    public static final int getLuminosity(int rgb) {
        float gray = 0.3f * (float)(rgb >> 16 & 0xFF) + 0.59f * (float)(rgb >> 8 & 0xFF) + 0.11f * (float)(rgb & 0xFF);
        return Math.round(gray);
    }

    public static String colorString(int argb) {
        int[] comp = PixelAudioMapper.rgbaComponents(argb);
        return "color(" + comp[0] + ", " + comp[1] + ", " + comp[2] + ", " + comp[3] + ")";
    }

    public static float hue(int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return hsbPixel[0];
    }

    public static float hue(int rgb) {
        float[] hsbTemp = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbTemp);
        return hsbTemp[0];
    }

    public static float saturation(int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return hsbPixel[1];
    }

    public static float saturation(int rgb) {
        float[] hsbTemp = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbTemp);
        return hsbTemp[1];
    }

    public static float brightness(int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return hsbPixel[2];
    }

    public static float brightness(int rgb) {
        float[] hsbTemp = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbTemp);
        return hsbTemp[2];
    }

    public static int colorShift(int rgbColor, float shift) {
        float[] hsb = new float[3];
        float h = PixelAudioMapper.hue(rgbColor, hsb);
        return Color.HSBtoRGB(h += shift, hsb[1], hsb[2]);
    }

    public static int applyBrightness(float sample, int rgb) {
        float[] hsbPixel = new float[3];
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], sample);
    }

    public static int applyBrightness(float sample, int rgb, float[] hsbPixel) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], sample);
    }

    public static int applyHue(float sample, int rgb) {
        float[] hsbPixel = new float[3];
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(sample, hsbPixel[1], hsbPixel[2]);
    }

    public static int applyHue(float sample, int rgb, float[] hsbPixel) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(sample, hsbPixel[1], hsbPixel[2]);
    }

    public static int applySaturation(float sample, int rgb) {
        float[] hsbPixel = new float[3];
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], sample, hsbPixel[2]);
    }

    public static int applySaturation(float sample, int rgb, float[] hsbPixel) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        sample = PixelAudioMapper.audioToHSBFloat(sample);
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], sample, hsbPixel[2]);
    }

    public static int applyRed(float sample, int rgb) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        int r = PixelAudioMapper.audioToRGBChan(sample);
        return 0xFF000000 | r << 16 | (rgb >> 8 & 0xFF) << 8 | rgb & 0xFF;
    }

    public static int applyGreen(float sample, int rgb) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        int g = PixelAudioMapper.audioToRGBChan(sample);
        return 0xFF000000 | (rgb >> 16 & 0xFF) << 16 | g << 8 | rgb & 0xFF;
    }

    public static int applyBlue(float sample, int rgb) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        int b = PixelAudioMapper.audioToRGBChan(sample);
        return 0xFF000000 | (rgb >> 16 & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | b & 0xFF;
    }

    public static int applyAlpha(float sample, int rgb) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        int a = PixelAudioMapper.audioToRGBChan(sample);
        return a << 24 | (rgb >> 16 & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb & 0xFF;
    }

    public static int applyAll(float sample, int rgb) {
        sample = sample > 1.0f ? 1.0f : (sample < -1.0f ? -1.0f : sample);
        int v = PixelAudioMapper.audioToRGBChan(sample);
        return 0xFF000000 | v << 16 | v << 8 | v;
    }

    public static int applyBrightness(int rgbSource, int rgb) {
        float[] hsbPixel = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], PixelAudioMapper.brightness(rgbSource));
    }

    public static int applyBrightness(int rgbSource, int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], PixelAudioMapper.brightness(rgbSource));
    }

    public static int applyHue(int rgbSource, int rgb) {
        float[] hsbPixel = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(PixelAudioMapper.hue(rgbSource), hsbPixel[1], hsbPixel[2]);
    }

    public static int applyHue(int rgbSource, int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(PixelAudioMapper.hue(rgbSource), hsbPixel[1], hsbPixel[2]);
    }

    public static int applySaturation(int rgbSource, int rgb) {
        float[] hsbPixel = new float[3];
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], PixelAudioMapper.saturation(rgbSource), hsbPixel[2]);
    }

    public static int applySaturation(int rgbSource, int rgb, float[] hsbPixel) {
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], PixelAudioMapper.saturation(rgbSource), hsbPixel[2]);
    }

    public static int applyRed(int rgbSource, int rgb) {
        int r = PixelAudioMapper.rgbComponents(rgbSource)[0];
        return 0xFF000000 | r << 16 | (rgb >> 8 & 0xFF) << 8 | rgb & 0xFF;
    }

    public static int applyGreen(int rgbSource, int rgb) {
        int g = PixelAudioMapper.rgbComponents(rgbSource)[1];
        return 0xFF000000 | (rgb >> 16 & 0xFF) << 16 | g << 8 | rgb & 0xFF;
    }

    public static int applyBlue(int rgbSource, int rgb) {
        int b = PixelAudioMapper.rgbComponents(rgbSource)[2];
        return 0xFF000000 | (rgb >> 16 & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | b & 0xFF;
    }

    public static int applyAll(int rgbSource, int rgb) {
        return rgbSource;
    }

    public static int applyColor(int colorSource, int graySource) {
        float[] hsbPixel = new float[3];
        Color.RGBtoHSB(colorSource >> 16 & 0xFF, colorSource >> 8 & 0xFF, colorSource & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], PixelAudioMapper.brightness(graySource));
    }

    public static int applyColor(int colorSource, int graySource, float[] hsbPixel) {
        Color.RGBtoHSB(colorSource >> 16 & 0xFF, colorSource >> 8 & 0xFF, colorSource & 0xFF, hsbPixel);
        return Color.HSBtoRGB(hsbPixel[0], hsbPixel[1], PixelAudioMapper.brightness(graySource));
    }

    public static int[] applyColor(int[] colorSource, int[] graySource, int[] lut) {
        if (colorSource == null || graySource == null || lut == null) {
            throw new IllegalArgumentException("colorSource, graySource and lut cannot be null.");
        }
        if (colorSource.length != graySource.length || colorSource.length != lut.length) {
            throw new IllegalArgumentException("colorSource, graySource and lut must all have the same length.");
        }
        float[] hsbPixel = new float[3];
        int i = 0;
        while (i < graySource.length) {
            graySource[i] = PixelAudioMapper.applyColor(colorSource[lut[i]], graySource[i], hsbPixel);
            ++i;
        }
        return graySource;
    }

    public static enum ChannelNames {
        R("Red", 0, (rgb, hsb) -> rgb >> 16 & 0xFF),
        G("Green", 1, (rgb, hsb) -> rgb >> 8 & 0xFF),
        B("Blue", 2, (rgb, hsb) -> rgb & 0xFF),
        H("Hue", 0, (rgb, hsb) -> {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
            return hsb[0];
        }),
        S("Saturation", 1, (rgb, hsb) -> {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
            return hsb[1];
        }),
        L("Brightness", 2, (rgb, hsb) -> {
            Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, hsb);
            return hsb[2];
        }),
        A("Alpha", 3, (rgb, hsb) -> rgb >> 24 & 0xFF),
        ALL("All channels", -1, (rgb, hsb) -> 0.3f * (float)(rgb >> 16 & 0xFF) + 0.59f * (float)(rgb >> 8 & 0xFF) + 0.11f * (float)(rgb & 0xFF));

        private final String displayName;
        private final int index;
        private final ChannelExtractor extractor;

        private ChannelNames(String displayName, int index, ChannelExtractor extractor) {
            this.displayName = displayName;
            this.index = index;
            this.extractor = extractor;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getIndex() {
            return this.index;
        }

        public float extract(int rgb, float[] hsbPixel) {
            return this.extractor.extract(rgb, hsbPixel);
        }

        @FunctionalInterface
        public static interface ChannelExtractor {
            public float extract(int var1, float[] var2);
        }
    }
}

