/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.BitmapTransform;

public abstract class PixelMapGen {
    public int w;
    public int h;
    public int size;
    public int[] pixelMap;
    public int[] sampleMap;
    public ArrayList<int[]> coords;
    public AffineTransformType transformType = AffineTransformType.NADA;
    public static final String description = "Declare the description variable in your class and describe your PixelMapGen.";
    public static AffineTransformType r270 = AffineTransformType.R270;
    public static AffineTransformType r90 = AffineTransformType.R90;
    public static AffineTransformType r180 = AffineTransformType.R180;
    public static AffineTransformType flipx = AffineTransformType.FLIPX;
    public static AffineTransformType fx270 = AffineTransformType.FX270;
    public static AffineTransformType fx90 = AffineTransformType.FX90;
    public static AffineTransformType flipy = AffineTransformType.FLIPY;
    public static AffineTransformType nada = AffineTransformType.NADA;
    public static AffineTransformType[] transArray = new AffineTransformType[]{r270, r90, r180, flipx, fx270, fx90, flipy, nada};

    public PixelMapGen(int width, int height, AffineTransformType type) {
        if (!this.validate(width, height)) {
            System.out.println("Error: Validation failed");
            return;
        }
        this.w = width;
        this.h = height;
        this.size = this.h * this.w;
        this.transformType = type;
    }

    public PixelMapGen(int width, int height) {
        this(width, height, AffineTransformType.NADA);
    }

    public abstract String describe();

    public abstract boolean validate(int var1, int var2);

    public abstract int[] generate();

    public int[] setMapsFromCoords(ArrayList<int[]> coordinates) {
        if (this.transformType != AffineTransformType.NADA) {
            this.transformCoords(coordinates, this.transformType);
        }
        this.loadIndexMaps();
        return this.pixelMap;
    }

    public void transformCoords(ArrayList<int[]> coordinates, AffineTransformType type) {
        ArrayList<int[]> transformedCoords = new ArrayList<int[]>(coordinates.size());
        for (int[] xy : coordinates) {
            int[] newXY = BitmapTransform.coordTransform(xy[0], xy[1], this.w, this.h, type);
            transformedCoords.add(newXY);
        }
        this.coords = transformedCoords;
        if (type == AffineTransformType.R270 || type == AffineTransformType.R90 || type == AffineTransformType.FX270 || type == AffineTransformType.FX90) {
            int temp = this.w;
            this.w = this.h;
            this.h = temp;
        }
    }

    public void loadIndexMaps() {
        int p = 0;
        int i = 0;
        this.pixelMap = new int[this.size];
        for (int[] loc : this.coords) {
            p = loc[0] + loc[1] * this.w;
            this.pixelMap[i++] = p;
        }
        this.sampleMap = new int[this.size];
        i = 0;
        while (i < this.w * this.h) {
            this.sampleMap[this.pixelMap[i]] = i;
            ++i;
        }
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getPixelMap() {
        return this.pixelMap;
    }

    public int[] getPixelMapCopy() {
        return Arrays.copyOf(this.pixelMap, this.size);
    }

    public int[] getSampleMap() {
        return this.sampleMap;
    }

    public int[] getSampleMapCopy() {
        return Arrays.copyOf(this.sampleMap, this.size);
    }

    public ArrayList<int[]> getCoordinates() {
        return this.coords;
    }

    public ArrayList<int[]> getCoordinatesCopy() {
        ArrayList<int[]> coordsCopy = new ArrayList<int[]>(this.size);
        for (int[] coord : this.coords) {
            coordsCopy.add(coord);
        }
        return coordsCopy;
    }

    public AffineTransformType getTransformType() {
        return this.transformType;
    }

    public void setTransformType(AffineTransformType transformType) {
        this.transformType = transformType;
        this.transformCoords(this.coords, this.transformType);
        this.loadIndexMaps();
    }

    public static boolean isPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    public static int findPowerOfTwo(int n) {
        if (n <= 0 || (n & n - 1) != 0) {
            throw new IllegalArgumentException("The number must be a positive power of 2. n = " + n);
        }
        return Integer.numberOfTrailingZeros(n);
    }

    public static int findNearestPowerOfTwoLessThan(int n) {
        if (n <= 1) {
            throw new IllegalArgumentException("There is no power of 2 less than the given number.");
        }
        int p = 1;
        while (p < n) {
            p <<= 1;
        }
        return p >> 1;
    }

    public static int[] getPixelMapFromCoordinates(ArrayList<int[]> coordsList, int w) {
        if (coordsList == null) {
            throw new IllegalArgumentException("ERROR: The coordList argument must be non-null.");
        }
        int p = 0;
        int i = 0;
        int[] pixelMap = new int[coordsList.size()];
        for (int[] loc : coordsList) {
            p = loc[0] + loc[1] * w;
            pixelMap[i++] = p;
        }
        return pixelMap;
    }

    public static int[] getInversMapFromPixelArray(int[] pixelArr) {
        int[] inverseArr = new int[pixelArr.length];
        int i = 0;
        while (i < pixelArr.length) {
            inverseArr[pixelArr[i]] = i;
            ++i;
        }
        return inverseArr;
    }

    public static AffineTransformType randomTransform(Random rand) {
        return transArray[rand.nextInt(transArray.length)];
    }
}

