/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.paulhertz.pixelaudio.AffineTransformType;
import net.paulhertz.pixelaudio.PixelMapGen;

@Deprecated
public class RandomContinousGen
extends PixelMapGen {
    public static final String description = "RandomContinousGen starts at (0,0) makes random choices of the next pixels until it creates a continous path.";

    public RandomContinousGen(int width, int height, AffineTransformType type) {
        super(width, height, type);
        this.generate();
    }

    public RandomContinousGen(int width, int height) {
        super(width, height);
        this.generate();
    }

    @Override
    public String describe() {
        return description;
    }

    @Override
    public boolean validate(int width, int height) {
        if (width < 2 || height < 2) {
            System.out.println("Width and height for BoustropheGen must be greater than 1.");
            return false;
        }
        return true;
    }

    @Override
    public int[] generate() {
        this.coords = this.generateCoordinates();
        return this.setMapsFromCoords(this.coords);
    }

    private ArrayList<int[]> generateCoordinates() {
        return this.generateHamiltonianPath(this.w, this.h, 1024);
    }

    public ArrayList<int[]> generateHamiltonianPath(int width, int height, int maxAttempts) {
        int endX = width - 1;
        int endY = 0;
        int attempt = 0;
        while (attempt < maxAttempts) {
            boolean[][] visited = new boolean[height][width];
            ArrayList<int[]> path = new ArrayList<int[]>(width * height);
            if (this.dfs(0, 0, width, height, visited, path, endX, endY)) {
                return path;
            }
            ++attempt;
        }
        System.out.println("--->> Hamiltonian path calculation failed over " + maxAttempts + " tries.");
        return this.generateRandomContinuousCoordinates(width, height);
    }

    private boolean dfs(int x, int y, int width, int height, boolean[][] visited, ArrayList<int[]> path, int endX, int endY) {
        if (visited[y][x]) {
            return false;
        }
        visited[y][x] = true;
        path.add(new int[]{x, y});
        if (path.size() == width * height) {
            return x == endX && y == endY;
        }
        int[][] nArray = this.shuffledDirections();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int[] dir = nArray[n2];
            int nx = x + dir[0];
            int ny = y + dir[1];
            if (this.inBounds(nx, ny, width, height) && !visited[ny][nx] && this.dfs(nx, ny, width, height, visited, path, endX, endY)) {
                return true;
            }
            ++n2;
        }
        visited[y][x] = false;
        path.remove(path.size() - 1);
        return false;
    }

    private boolean inBounds(int x, int y, int width, int height) {
        return x >= 0 && y >= 0 && x < width && y < height;
    }

    private int[][] shuffledDirections() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        int[][] dirs = nArrayArray;
        List dirList = Arrays.asList(dirs);
        Collections.shuffle(dirList);
        return (int[][])dirList.toArray((T[])new int[0][]);
    }

    private ArrayList<int[]> generateBoustrophedonPath(int width, int height) {
        ArrayList<int[]> path = new ArrayList<int[]>(width * height);
        int y = 0;
        while (y < height) {
            if (y % 2 == 0) {
                x = 0;
                while (x < width) {
                    path.add(new int[]{x++, y});
                }
            } else {
                x = width - 1;
                while (x >= 0) {
                    path.add(new int[]{x--, y});
                }
            }
            ++y;
        }
        return path;
    }

    private ArrayList<int[]> generateRandomContinuousCoordinates(int width, int height) {
        ArrayList<int[]> path = new ArrayList<int[]>(width * height);
        boolean[][] visited = new boolean[height][width];
        Random rand = new Random(System.nanoTime());
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        int[][] directions = nArrayArray;
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[2]);
        visited[0][0] = true;
        path.add(new int[2]);
        while (!stack.isEmpty()) {
            int[] current = (int[])stack.peek();
            int cx = current[0];
            int cy = current[1];
            ArrayList<int[]> neighbors = new ArrayList<int[]>();
            int[][] nArrayArray2 = directions;
            int n = directions.length;
            int n2 = 0;
            while (n2 < n) {
                int[] dir = nArrayArray2[n2];
                int nx = cx + dir[0];
                int ny = cy + dir[1];
                if (nx >= 0 && ny >= 0 && nx < width && ny < height && !visited[ny][nx]) {
                    neighbors.add(new int[]{nx, ny});
                }
                ++n2;
            }
            if (neighbors.isEmpty()) {
                stack.pop();
                continue;
            }
            int[] next = (int[])neighbors.get(rand.nextInt(neighbors.size()));
            visited[next[1]][next[0]] = true;
            stack.push(next);
            path.add(next);
        }
        return path;
    }
}

