/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import net.paulhertz.pixelaudio.OpenSimplex2;

public class ScaledSimplex {
    private OpenSimplex2 generator = new OpenSimplex2();
    int octaves = 4;
    float detail = 0.5f;
    float inc = 0.00625f;
    float noiz = 0.0f;
    int seed;

    public ScaledSimplex() {
        this((int)System.currentTimeMillis());
    }

    public ScaledSimplex(int seed) {
        this.seed = seed;
    }

    public ScaledSimplex(int octaves, float detail) {
        this((int)System.currentTimeMillis());
        this.octaves = octaves;
        this.detail = detail;
    }

    public ScaledSimplex(int octaves, float detail, int seed) {
        this(seed);
        this.octaves = octaves;
        this.detail = detail;
    }

    public ScaledSimplex(int octaves, float detail, float inc) {
        this((int)System.currentTimeMillis());
        this.octaves = octaves;
        this.detail = detail;
        this.inc = inc;
    }

    public ScaledSimplex(int octaves, float detail, float inc, int seed) {
        this(seed);
        this.octaves = octaves;
        this.detail = detail;
        this.inc = inc;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int newSeed) {
        this.seed = newSeed;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int octaves) {
        this.octaves = octaves;
    }

    public float getDetail() {
        return this.detail;
    }

    public void setDetail(float detail) {
        this.detail = detail;
    }

    public float getInc() {
        return this.inc;
    }

    public void setInc(float inc) {
        this.inc = inc;
    }

    public float getNoiz() {
        return this.noiz;
    }

    public void setNoiz(float noiz) {
        this.noiz = noiz;
    }

    public float noise2(int iter, float x, float y, float det, float scale, float low, float high) {
        float maxAmp = 0.0f;
        float amp = 1.0f;
        float freq = scale;
        this.noiz = 0.0f;
        int i = 0;
        while (i < iter) {
            this.noiz += OpenSimplex2.noise2(this.seed, x * freq, y * freq) * amp;
            maxAmp += amp;
            amp *= det;
            freq *= 2.0f;
            ++i;
        }
        this.noiz /= maxAmp;
        this.noiz = this.noiz * (high - low) / 2.0f + (high + low) / 2.0f;
        return this.noiz;
    }

    public float noise1(float x) {
        return this.noise2(this.octaves, x, 0.0f, this.detail, this.inc, -1.0f, 1.0f);
    }

    public float noise2(float x, float y) {
        return this.noise2(this.octaves, x, y, this.detail, this.inc, -1.0f, 1.0f);
    }

    public float noise2(float x, float y, float low, float high) {
        return this.noise2(this.octaves, x, y, this.detail, this.inc, low, high);
    }

    public float noise3(int iter, float x, float y, float z, float det, float scale, float low, float high) {
        float maxAmp = 0.0f;
        float amp = 1.0f;
        float freq = scale;
        this.noiz = 0.0f;
        int i = 0;
        while (i < iter) {
            this.noiz += OpenSimplex2.noise3_ImproveXY(this.seed, x * freq, y * freq, z * freq) * amp;
            maxAmp += amp;
            amp *= det;
            freq *= 2.0f;
            ++i;
        }
        this.noiz /= maxAmp;
        this.noiz = this.noiz * (high - low) / 2.0f + (high + low) / 2.0f;
        return this.noiz;
    }

    public float noise3(float x, float y, float z) {
        return this.noise3(this.octaves, x, y, z, this.detail, this.inc, -1.0f, 1.0f);
    }

    public float noise3(float x, float y, float z, float low, float high) {
        return this.noise3(this.octaves, x, y, z, this.detail, this.inc, low, high);
    }
}

