/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.PixelAudioMapper;

public class WaveData {
    public float freq;
    public float amp;
    public float phase;
    public float phaseTwoPi;
    public float phaseCycles;
    public float phaseInc = 0.0f;
    public float dc = 0.0f;
    public int waveColor;
    public boolean isMuted = false;
    public WaveState waveState;
    public int animSteps = defaultAnimSteps;
    public static int defaultAnimSteps = 720;
    public static final boolean phaseScalesTwoPI = true;

    public WaveData(float f, float a, float p, float dc, float cycles, int c, int animSteps, boolean phaseScalesTwoPi) {
        this.freq = f;
        this.amp = a;
        this.phase = p;
        this.phaseTwoPi = phaseScalesTwoPi ? p * ((float)Math.PI * 2) : p;
        this.setDc(dc);
        this.phaseCycles = cycles;
        this.animSteps = animSteps;
        this.phaseInc = cycles * ((float)Math.PI * 2) / (float)animSteps;
        this.waveColor = c;
        this.waveState = WaveState.ACTIVE;
    }

    public WaveData(float f, float a, float p, float dc, float cycles, int c, int steps) {
        this(f, a, p, dc, cycles, c, steps, true);
    }

    public WaveData(float f, float a, float p, float dc, float cycles, int c) {
        this(f, a, p, dc, cycles, c, defaultAnimSteps, true);
    }

    public WaveData() {
        this(440.0f, 0.5f, 0.5f, 0.0f, 1.0f, PixelAudioMapper.composeColor(127, 127, 127), defaultAnimSteps, true);
    }

    public void updateWaveData(float f, float a, float p, float cycles, int c, int steps) {
        this.freq = f;
        this.amp = a;
        this.phase = p;
        this.animSteps = steps;
        this.phaseTwoPi = p * ((float)Math.PI * 2);
        this.phaseCycles = cycles;
        this.phaseInc = cycles * ((float)Math.PI * 2) / (float)this.animSteps;
        this.waveColor = c;
    }

    public void setFreq(float f) {
        this.freq = f;
    }

    public void setAmp(float a) {
        this.amp = a;
    }

    public void setPhase(float p, boolean phaseScalesTwoPi) {
        this.phase = p;
        this.phaseTwoPi = phaseScalesTwoPi ? p * ((float)Math.PI * 2) : p;
    }

    public void setPhase(float p) {
        this.setPhase(p, true);
    }

    public void setCycles(float cycles, int steps) {
        this.phaseCycles = cycles;
        this.animSteps = steps;
        this.phaseInc = cycles * ((float)Math.PI * 2) / (float)this.animSteps;
    }

    public void setCycles(float cycles) {
        this.phaseCycles = cycles;
        this.phaseInc = cycles * ((float)Math.PI * 2) / (float)this.animSteps;
    }

    public void setAnimationSteps(int newSteps) {
        this.animSteps = newSteps;
        this.phaseInc = this.phaseCycles * ((float)Math.PI * 2) / (float)this.animSteps;
    }

    public void setDc(float newDc) {
        this.dc = newDc;
    }

    public void setWaveColor(int c) {
        this.waveColor = c;
    }

    public void setWaveState(WaveState newWaveState) {
        this.waveState = newWaveState;
        this.isMuted = this.waveState == WaveState.ACTIVE ? false : this.waveState != WaveState.SOLO;
    }

    public float waveValue(int frame, int pos, float freqShift, float mapInc) {
        return (float)Math.sin(this.phaseTwoPi - (float)frame * this.phaseInc + this.freq * freqShift * (float)pos * mapInc);
    }

    public float waveValue(int frame, int pos, float mapInc) {
        return (float)Math.sin(this.phaseTwoPi - (float)frame * this.phaseInc + this.freq * (float)pos * mapInc);
    }

    public float rawPhaseAtFrame(int frame) {
        return this.phaseTwoPi - (float)frame * this.phaseInc;
    }

    public float phaseAtFrame(int frame) {
        return (this.rawPhaseAtFrame(frame) % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public float scaledPhaseAtFrame(int frame) {
        float range = 1.0f;
        float value = this.phase - (float)frame * this.phaseCycles / (float)this.animSteps;
        return (value % range + range) % range;
    }

    public static float mapToPositivePhase(float value, float a, float b) {
        float range = b - a;
        return ((value - a) % range + range) % range + a;
    }

    public static ArrayList<WaveData> waveDataListCopy(ArrayList<WaveData> wdList) {
        ArrayList<WaveData> wdListCopy = new ArrayList<WaveData>();
        for (WaveData wd : wdList) {
            wdListCopy.add(wd.clone());
        }
        return wdListCopy;
    }

    public WaveData clone() {
        return new WaveData(this.freq, this.amp, this.phase, this.dc, this.phaseCycles, this.waveColor, this.animSteps);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("freq: " + this.freq + ", ");
        sb.append("amp: " + this.amp + ", ");
        sb.append("phase: " + this.phase + ", ");
        sb.append("dc: " + this.dc + ", ");
        sb.append("cycles: " + this.phaseCycles + ", ");
        int[] rgb = PixelAudioMapper.rgbComponents(this.waveColor);
        sb.append("color: (" + rgb[0] + ", " + rgb[1] + ", " + rgb[2] + "), ");
        String muted = this.isMuted ? "Y" : "N";
        sb.append("mute: " + muted);
        return sb.toString();
    }

    public static enum WaveState {
        ACTIVE,
        SOLO,
        MUTE,
        SUSPENDED;

    }
}

