/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.PixelAudio;
import net.paulhertz.pixelaudio.PixelAudioMapper;
import net.paulhertz.pixelaudio.WaveData;
import processing.core.PImage;

public class WaveSynth {
    public PixelAudioMapper mapper;
    public PImage mapImage;
    public int[] colorSignal;
    public float[] audioSignal;
    public float[] renderSignal;
    public ArrayList<WaveData> waveDataList;
    boolean isRenderAudio = false;
    private int w;
    private int h;
    public int mapSize;
    public int dataLength;
    public float gain = 1.0f;
    public float gamma = 1.0f;
    public int[] gammaTable;
    public boolean useGammaTable = true;
    public boolean isScaleHisto = false;
    public int histoLow = 1;
    public int histoHigh = 254;
    public int animSteps = 720;
    public int step = 0;
    public int stop = 0;
    public float noisiness = 0.0f;
    public String comments = "---";
    public float sampleRate;
    public float mapInc;
    public float[] weights;
    public int[] waveColors;
    public int[] maskScan;
    public float woff = 1.0f;
    public float wscale = 0.5f;
    public int videoFrameRate = 24;
    public String videoFilename = "motion_study.mp4";

    public WaveSynth(PixelAudioMapper mapper, ArrayList<WaveData> wdList) {
        this.setMapper(mapper);
        this.setWaveData(wdList);
    }

    public WaveSynth(PixelAudioMapper mapper) {
        this(mapper, WaveSynth.quickWaveDataList());
    }

    public void setMapper(PixelAudioMapper mapper) {
        this.mapper = mapper;
        this.w = mapper.getWidth();
        this.h = mapper.getHeight();
        this.mapSize = this.w * this.h;
        this.sampleRate = this.mapSize;
        this.mapImage = PixelAudio.myParent.createImage(this.w, this.h, 1);
        this.colorSignal = new int[this.mapSize];
        this.audioSignal = new float[this.mapSize];
    }

    public void setWaveData(ArrayList<WaveData> wdList) {
        this.waveDataList = wdList;
        this.dataLength = wdList.size();
        this.waveColors = new int[this.dataLength];
        int j = 0;
        while (j < this.dataLength) {
            this.waveColors[j] = this.waveDataList.get((int)j).waveColor;
            ++j;
        }
        this.weights = new float[this.dataLength];
    }

    public void updateWaveColors() {
        this.dataLength = this.waveDataList.size();
        if (this.waveColors == null || this.waveColors.length != this.dataLength) {
            this.waveColors = new int[this.dataLength];
            this.weights = new float[this.dataLength];
        }
        int j = 0;
        while (j < this.dataLength) {
            this.waveColors[j] = this.waveDataList.get((int)j).waveColor;
            ++j;
        }
    }

    public static ArrayList<WaveData> quickWaveDataList() {
        ArrayList<WaveData> list = new ArrayList<WaveData>();
        float frequency = 768.0f;
        float amplitude = 0.8f;
        float phase = 0.0f;
        float dc = 0.0f;
        float cycles = 1.0f;
        int waveColor = PixelAudioMapper.composeColor(159, 190, 251);
        int steps = 240;
        WaveData wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        frequency = 192.0f;
        phase = 0.0f;
        cycles = 2.0f;
        waveColor = PixelAudioMapper.composeColor(209, 178, 117);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        return list;
    }

    public ArrayList<WaveData> getWaveDataList() {
        return this.waveDataList;
    }

    public void setWaveDataList(ArrayList<WaveData> waveDataList) {
        this.setWaveData(waveDataList);
    }

    public float getGain() {
        return this.gain;
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        if ((double)gamma != 1.0) {
            this.gammaTable = new int[256];
            int i = 0;
            while (i < this.gammaTable.length) {
                float c = (float)i / (float)(this.gammaTable.length - 1);
                this.gammaTable[i] = (int)Math.round(Math.pow(c, gamma) * (double)(this.gammaTable.length - 1));
                ++i;
            }
        }
    }

    public boolean isScaleHisto() {
        return this.isScaleHisto;
    }

    public void setScaleHisto(boolean isScaleHisto) {
        this.isScaleHisto = isScaleHisto;
    }

    public int getHistoLow() {
        return this.histoLow;
    }

    public void setHistoLow(int histoLow) {
        this.histoLow = histoLow;
    }

    public int getHistoHigh() {
        return this.histoHigh;
    }

    public void setHistoHigh(int histoHigh) {
        this.histoHigh = histoHigh;
    }

    public float getNoiseiness() {
        return this.noisiness;
    }

    public void setNoiseiness(float noiseiness) {
        this.noisiness = noiseiness;
    }

    public int getAnimSteps() {
        return this.animSteps;
    }

    public void setAnimSteps(int animSteps) {
        this.animSteps = animSteps;
        if (this.waveDataList != null) {
            for (WaveData wd : this.waveDataList) {
                wd.phaseInc = wd.phaseCycles * ((float)Math.PI * 2) / (float)this.animSteps;
            }
        }
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getVideoFrameRate() {
        return this.videoFrameRate;
    }

    public void setVideoFrameRate(int videoFrameRate) {
        this.videoFrameRate = videoFrameRate;
    }

    public String getVideoFilename() {
        return this.videoFilename;
    }

    public void setVideoFilename(String videoFilename) {
        this.videoFilename = videoFilename;
    }

    public PixelAudioMapper getMapper() {
        return this.mapper;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float newSampleRate) {
        this.sampleRate = newSampleRate;
        this.mapInc = (float)Math.PI * 2 / this.sampleRate;
    }

    public WaveSynth clone() {
        WaveSynth myClone = new WaveSynth(this.mapper, this.waveDataList);
        myClone.setGain(this.gain);
        myClone.setGamma(this.gamma);
        myClone.setScaleHisto(this.isScaleHisto);
        myClone.setHistoLow(this.histoLow);
        myClone.setHistoHigh(this.histoHigh);
        myClone.setVideoFrameRate(this.videoFrameRate);
        myClone.setVideoFilename(this.videoFilename);
        myClone.setComments(this.comments);
        myClone.setWaveDataList(WaveData.waveDataListCopy(this.waveDataList));
        myClone.setAnimSteps(this.animSteps);
        myClone.setStep(this.step);
        myClone.setSampleRate(this.sampleRate);
        return myClone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Animation steps: " + this.getAnimSteps() + "\n");
        sb.append("blendFactor: " + this.getGain() + "\n");
        sb.append("gamma: " + this.getGamma() + "\n");
        if (this.isScaleHisto()) {
            sb.append("scaleHisto: " + this.isScaleHisto() + "\n");
            sb.append("histoLow: " + this.getHistoLow() + "\n");
            sb.append("histoHigh: " + this.getHistoHigh() + "\n");
        }
        sb.append("comments: " + this.getComments() + "\n");
        sb.append("video filename: " + this.getVideoFilename() + "\n");
        sb.append("sampling frequency: " + this.getSampleRate() + "\n");
        sb.append("WaveData list: ");
        int i = 0;
        while (i < this.waveDataList.size()) {
            WaveData wd = this.waveDataList.get(i);
            sb.append("  " + (i + 1) + ":: " + wd.toString() + "\n");
            ++i;
        }
        return sb.toString();
    }

    public boolean isRenderAudio() {
        return this.isRenderAudio;
    }

    public void setRenderAudio(boolean isRenderAudio) {
        if (isRenderAudio) {
            this.renderSignal = new float[this.audioSignal.length];
        }
        this.isRenderAudio = isRenderAudio;
    }

    public void prepareAnimation() {
        this.mapImage.loadPixels();
        this.colorSignal = this.mapper.pluckPixels(this.mapImage.pixels, 0, this.mapSize);
        this.mapInc = (float)Math.PI * 2 / this.sampleRate;
    }

    public synchronized void renderFrame(int frame) {
        if (frame == 0) {
            this.prepareAnimation();
        }
        int i = 0;
        while (i < this.mapSize) {
            this.colorSignal[i] = this.renderPixel(frame, i, this.waveDataList);
            ++i;
        }
        this.mapper.plantPixels(this.colorSignal, this.mapImage.pixels, 0, this.mapSize);
        this.mapImage.updatePixels();
        if (this.isRenderAudio) {
            this.audioSignal = this.renderSignal;
        }
        this.setStep(frame);
    }

    public int renderPixel(int frame, int pos, ArrayList<WaveData> wdList) {
        int j = 0;
        while (j < this.dataLength) {
            WaveData wd = this.waveDataList.get(j);
            if (!wd.isMuted && wd.waveState != WaveData.WaveState.SUSPENDED) {
                float val = (wd.waveValue(frame, pos, this.mapInc) + this.woff) * this.wscale + wd.dc;
                this.weights[j] = val * wd.amp * this.gain;
            }
            ++j;
        }
        if (this.isRenderAudio) {
            float weightSum = 0.0f;
            int i = 0;
            while (i < this.weights.length) {
                weightSum += this.weights[i];
                ++i;
            }
            this.renderSignal[pos] = weightSum;
        }
        return this.weightedColor(this.waveColors, this.weights);
    }

    public int weightedColor(int[] colors, float[] weights) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int i = 0;
        while (i < colors.length) {
            int[] comp = PixelAudioMapper.rgbComponents(colors[i]);
            r += (float)comp[0] * weights[i];
            g += (float)comp[1] * weights[i];
            b += (float)comp[2] * weights[i];
            ++i;
        }
        if ((double)this.gamma != 1.0) {
            if (this.useGammaTable) {
                r = PixelAudio.constrain(r, 0.0f, 255.0f);
                r = this.gammaTable[(int)r];
                g = PixelAudio.constrain(g, 0.0f, 255.0f);
                g = this.gammaTable[(int)g];
                b = PixelAudio.constrain(b, 0.0f, 255.0f);
                b = this.gammaTable[(int)b];
            } else {
                r = (float)Math.pow((double)r / 255.0, this.gamma) * 255.0f;
                g = (float)Math.pow((double)g / 255.0, this.gamma) * 255.0f;
                b = (float)Math.pow((double)b / 255.0, this.gamma) * 255.0f;
            }
        }
        if (this.isScaleHisto) {
            r = PixelAudio.constrain(PixelAudio.map(r, this.histoLow, this.histoHigh, 1.0f, 254.0f), 0.0f, 255.0f);
            g = PixelAudio.constrain(PixelAudio.map(g, this.histoLow, this.histoHigh, 1.0f, 254.0f), 0.0f, 255.0f);
            b = PixelAudio.constrain(PixelAudio.map(b, this.histoLow, this.histoHigh, 1.0f, 254.0f), 0.0f, 255.0f);
        }
        return PixelAudioMapper.composeColor((int)r, (int)g, (int)b, 255);
    }

    public float[] renderAudio(int frame) {
        return this.renderAudio(frame, 0.95f);
    }

    public float[] renderAudioRaw(int frame) {
        int pos = 0;
        while (pos < this.mapSize) {
            int j = 0;
            while (j < this.dataLength) {
                WaveData wd = this.waveDataList.get(j);
                if (!wd.isMuted && wd.waveState != WaveData.WaveState.SUSPENDED) {
                    float val = (wd.waveValue(frame, pos, 1.0f, this.mapInc) + this.woff) * this.wscale + wd.dc;
                    this.weights[j] = val * wd.amp * this.gain;
                }
                ++j;
            }
            float weightSum = 0.0f;
            int i = 0;
            while (i < this.weights.length) {
                weightSum += this.weights[i];
                ++i;
            }
            this.audioSignal[pos] = weightSum;
            ++pos;
        }
        return this.audioSignal;
    }

    public float[] renderAudio(int frame, float limit) {
        int pos = 0;
        while (pos < this.mapSize) {
            int j = 0;
            while (j < this.dataLength) {
                WaveData wd = this.waveDataList.get(j);
                if (!wd.isMuted && wd.waveState != WaveData.WaveState.SUSPENDED) {
                    float val = (wd.waveValue(frame, pos, 1.0f, this.mapInc) + this.woff) * this.wscale + wd.dc;
                    this.weights[j] = val * wd.amp * this.gain;
                }
                ++j;
            }
            float weightSum = 0.0f;
            int i = 0;
            while (i < this.weights.length) {
                weightSum += this.weights[i];
                ++i;
            }
            this.audioSignal[pos] = weightSum;
            ++pos;
        }
        return WaveSynth.normalize(this.audioSignal, limit);
    }

    public float noiseAt(int x, int y) {
        float scale = 0.001f;
        float detail = 0.4f;
        PixelAudio.myParent.noiseDetail(6, detail);
        float px = (float)x * scale;
        float py = (float)y * scale;
        float g = PixelAudio.myParent.noise(px, py);
        g = PixelAudio.map(g, 0.0f, 1.0f, -0.5f, 0.5f) * this.noisiness;
        return 1.0f + g;
    }

    public static float[] normalize(float[] sig, float limit) {
        float min = 0.0f;
        float max = 0.0f;
        int i = 0;
        while (i < sig.length) {
            if (sig[i] < min) {
                min = sig[i];
            }
            if (sig[i] > max) {
                max = sig[i];
            }
            ++i;
        }
        i = 0;
        while (i < sig.length) {
            sig[i] = PixelAudio.map(sig[i], min, max, -limit, limit);
            ++i;
        }
        return sig;
    }

    public static float[] normalize(float[] sig) {
        return WaveSynth.normalize(sig, 1.0f);
    }

    public static int[] getHistoBounds(int[] source) {
        int min = 255;
        int max = 0;
        int i = 0;
        while (i < source.length) {
            int[] comp = PixelAudioMapper.rgbComponents(source[i]);
            int j = 0;
            while (j < comp.length) {
                if (comp[j] > max) {
                    max = comp[j];
                }
                if (comp[j] < min) {
                    min = comp[j];
                }
                ++j;
            }
            ++i;
        }
        return new int[]{min, max};
    }

    public static int[] stretch(int[] source, int low, int high) {
        int[] out = new int[source.length];
        int r = 0;
        int g = 0;
        int b = 0;
        int i = 0;
        while (i < out.length) {
            int[] comp = PixelAudioMapper.rgbComponents(source[i]);
            r = comp[0];
            g = comp[1];
            b = comp[2];
            r = (int)PixelAudio.constrain(PixelAudio.map(r, low, high, 0.0f, 255.0f), 0.0f, 255.0f);
            g = (int)PixelAudio.constrain(PixelAudio.map(g, low, high, 0.0f, 255.0f), 0.0f, 255.0f);
            b = (int)PixelAudio.constrain(PixelAudio.map(b, low, high, 0.0f, 255.0f), 0.0f, 255.0f);
            out[i] = PixelAudioMapper.composeColor(r, g, b, 255);
            ++i;
        }
        return out;
    }
}

