/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio;

import java.awt.Color;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.paulhertz.pixelaudio.PixelAudioMapper;
import net.paulhertz.pixelaudio.WaveData;
import net.paulhertz.pixelaudio.WaveSynth;
import processing.core.PApplet;
import processing.data.JSONArray;
import processing.data.JSONObject;

public class WaveSynthBuilder {
    public static final double semitoneFac = Math.pow(2.0, 0.08333333333333333);
    public static int animSteps = 720;

    public static ArrayList<WaveData> synthTrumpet(float fundamental, int howManyPartials, float pianoKey, int animSteps) {
        float funda;
        ArrayList<WaveData> list = new ArrayList<WaveData>();
        if (howManyPartials < 1) {
            howManyPartials = 1;
        }
        float frequency = funda = fundamental;
        float amplitude = 0.55f;
        float phase = 0.766f;
        float dc = 0.0f;
        float cycles = -8.0f;
        int waveColor = PixelAudioMapper.composeColor(0, 89, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        int steps = animSteps;
        WaveData wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 1) {
            return list;
        }
        frequency = 2.0f * funda;
        amplitude = 0.52f;
        phase = -0.89f;
        cycles = 8.0f;
        waveColor = PixelAudioMapper.composeColor(89, 199, 55);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 2) {
            return list;
        }
        frequency = 3.0f * funda;
        amplitude = 0.6f;
        phase = -0.486f;
        cycles = 3.0f;
        waveColor = PixelAudioMapper.composeColor(254, 89, 110);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 3) {
            return list;
        }
        frequency = 4.0f * funda;
        amplitude = 0.45f;
        phase = -0.18616974f;
        cycles = -2.0f;
        waveColor = PixelAudioMapper.composeColor(89, 110, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 4) {
            return list;
        }
        frequency = 5.0f * funda;
        amplitude = 0.42f;
        phase = 0.6846085f;
        cycles = -5.0f;
        waveColor = PixelAudioMapper.composeColor(233, 34, 21);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 5) {
            return list;
        }
        frequency = 6.0f * funda;
        amplitude = 0.45f;
        phase = 0.68912f;
        cycles = 13.0f;
        waveColor = PixelAudioMapper.composeColor(220, 199, 55);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 6) {
            return list;
        }
        frequency = 7.0f * funda;
        amplitude = 0.25f;
        phase = 0.68f;
        cycles = 11.0f;
        waveColor = PixelAudioMapper.composeColor(159, 190, 255);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        if (howManyPartials == 7) {
            return list;
        }
        frequency = 8.0f * funda;
        amplitude = 0.32f;
        phase = 0.68f;
        cycles = -11.0f;
        waveColor = PixelAudioMapper.composeColor(209, 178, 117);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        return list;
    }

    public static ArrayList<WaveData> synthDoubleStop(float funda1, float funda2, float pianoKey1, float pianoKey2, int animSteps) {
        ArrayList<WaveData> list = new ArrayList<WaveData>();
        float detune = 0.0625f;
        float funda = funda1;
        float pianoKey = pianoKey1;
        float frequency = funda1;
        float amplitude = 0.6f;
        float phase = 0.75f;
        float dc = 0.0f;
        float cycles = 1.0f;
        int waveColor = PixelAudioMapper.composeColor(0, 89, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        int steps = animSteps;
        WaveData wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        frequency = 2.0f * funda;
        amplitude = 0.4f;
        phase = -0.5f;
        cycles = -2.0f;
        waveColor = PixelAudioMapper.composeColor(89, 199, 55);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        frequency = 4.0f * funda + detune;
        amplitude = 0.3f;
        phase = -0.125f;
        cycles = 3.0f;
        waveColor = PixelAudioMapper.composeColor(89, 110, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        funda = funda2;
        pianoKey = pianoKey2;
        frequency = funda2;
        amplitude = 0.6f;
        phase = 0.5f;
        dc = 0.0f;
        cycles = -1.0f;
        waveColor = PixelAudioMapper.composeColor(0, 89, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        frequency = 2.0f * funda;
        amplitude = 0.4f;
        phase = 0.75f;
        cycles = 2.0f;
        waveColor = PixelAudioMapper.composeColor(89, 199, 55);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        frequency = 4.0f * funda - detune;
        amplitude = 0.3f;
        phase = 0.125f;
        cycles = -3.0f;
        waveColor = PixelAudioMapper.composeColor(89, 110, 233);
        waveColor = PixelAudioMapper.colorShift(waveColor, pianoKey % 12.0f / 12.0f);
        wd = new WaveData(frequency, amplitude, phase, dc, cycles, waveColor, steps);
        list.add(wd);
        return list;
    }

    public static float[] chromaticScale(float funda) {
        float[] chromaScale = new float[12];
        int i = 0;
        while (i < chromaScale.length) {
            chromaScale[i] = funda;
            funda *= (float)((double)funda * semitoneFac);
            ++i;
        }
        return chromaScale;
    }

    public static float pianoKeyFrequency(float keyNumber) {
        return (float)(440.0 * Math.pow(2.0, (double)(keyNumber - 49.0f) / 12.0));
    }

    public static float frequencyPianoKey(float freq) {
        return 49.0f + 12.0f * (float)(Math.log(freq / 440.0f) / Math.log(2.0));
    }

    public static int colorShift(int c, float shift) {
        float[] hsb = new float[3];
        float h = PixelAudioMapper.hue(c, hsb);
        return Color.HSBtoRGB(h += shift, hsb[1], hsb[2]);
    }

    public static void scaleAmps(ArrayList<WaveData> waveDataList, float scale, boolean isVerbose) {
        int i = 0;
        for (WaveData wd : waveDataList) {
            if (wd.isMuted) {
                ++i;
                continue;
            }
            wd.setAmp(wd.amp * scale);
            if (!isVerbose) continue;
            System.out.println("----- set amplitude " + i + " to " + wd.amp);
        }
    }

    public static void shiftColors(ArrayList<WaveData> waveDataList, float shift, boolean isVerbose) {
        for (WaveData wd : waveDataList) {
            if (wd.isMuted) continue;
            wd.setWaveColor(WaveSynthBuilder.colorShift(wd.waveColor, shift));
        }
        if (isVerbose) {
            System.out.println("----->>> shift colors " + shift);
        }
    }

    public static void scaleFreqs(ArrayList<WaveData> waveDataList, float scale, boolean isVerbose) {
        int i = 0;
        for (WaveData wd : waveDataList) {
            if (wd.isMuted) {
                ++i;
                continue;
            }
            wd.setFreq(wd.freq * scale);
            if (!isVerbose) continue;
            System.out.println("----- set frequency " + i + " to " + wd.freq);
        }
    }

    public static void shiftPhases(ArrayList<WaveData> waveDataList, float shift, boolean isVerbose) {
        for (WaveData wd : waveDataList) {
            if (wd.isMuted) continue;
            wd.setPhase(wd.phase + shift);
        }
        if (isVerbose) {
            System.out.println("----->>> shiftPhase " + shift);
        }
    }

    public static void showPhaseValues(WaveSynth wavesynth) {
        float m;
        ArrayList<WaveData> waveDataList = wavesynth.getWaveDataList();
        int phaseStep = wavesynth.getStep();
        StringBuffer sb = new StringBuffer("\n----- current phase values scaled over (0, 1) -----\n");
        int i = 1;
        for (WaveData wd : waveDataList) {
            m = wd.scaledPhaseAtFrame(phaseStep);
            sb.append(i++ + ": " + PApplet.nf((float)m) + "; ");
        }
        sb.append("\n----- current phase values scaled over (0, TWO_PI) -----\n");
        i = 1;
        for (WaveData wd : waveDataList) {
            m = wd.phaseAtFrame(phaseStep);
            sb.append(i++ + ": " + PApplet.nf((float)m) + "; ");
        }
        System.out.println(sb);
    }

    public static void capturePhaseValues(WaveSynth wavesynth) {
        ArrayList<WaveData> waveDataList = wavesynth.getWaveDataList();
        int phaseStep = wavesynth.getStep();
        for (WaveData wd : waveDataList) {
            float currentPhase = wd.scaledPhaseAtFrame(phaseStep);
            wd.setPhase(currentPhase);
        }
    }

    public static void toggleWDMute(WaveSynth wavesynth, int elem) {
        if (wavesynth.waveDataList.size() < elem + 1) {
            return;
        }
        WaveData wd = wavesynth.waveDataList.get(elem);
        wd.isMuted = !wd.isMuted;
        wd.waveState = wd.isMuted ? WaveData.WaveState.MUTE : WaveData.WaveState.ACTIVE;
    }

    public static void muteWaveData(WaveSynth wavesynth, int elem) {
        if (wavesynth.waveDataList.size() < elem + 1) {
            return;
        }
        WaveData wd = wavesynth.waveDataList.get(elem);
        wd.waveState = WaveData.WaveState.MUTE;
    }

    public static void unmuteWaveData(WaveSynth wavesynth, int elem) {
        if (wavesynth.waveDataList.size() < elem + 1) {
            return;
        }
        WaveData wd = wavesynth.waveDataList.get(elem);
        wd.waveState = WaveData.WaveState.ACTIVE;
    }

    public static void unmuteAllWD(ArrayList<WaveData> waveDataList) {
        StringBuffer sb = new StringBuffer("Audio operators\n");
        int n = 1;
        for (WaveData wd : waveDataList) {
            wd.setWaveState(WaveData.WaveState.ACTIVE);
            sb.append("wave " + n++ + " " + wd.waveState.toString() + ", ");
        }
        System.out.println(sb.toString());
    }

    public static void toggleWDSolo(WaveSynth wavesynth, int elem, boolean isSolo) {
        block5: {
            block4: {
                if (wavesynth.waveDataList.size() < elem + 1) {
                    return;
                }
                WaveData currentWD = wavesynth.waveDataList.get(elem);
                WaveData.WaveState waveState = currentWD.waveState = isSolo ? WaveData.WaveState.SOLO : WaveData.WaveState.ACTIVE;
                if (currentWD.waveState != WaveData.WaveState.SOLO) break block4;
                for (WaveData wd : wavesynth.waveDataList) {
                    if (wd == currentWD || wd.waveState != WaveData.WaveState.ACTIVE) continue;
                    wd.waveState = WaveData.WaveState.SUSPENDED;
                    wd.isMuted = true;
                }
                break block5;
            }
            boolean listHasSolos = false;
            for (WaveData wd : wavesynth.waveDataList) {
                if (wd.waveState != WaveData.WaveState.SOLO) continue;
                listHasSolos = true;
            }
            if (listHasSolos) break block5;
            for (WaveData wd : wavesynth.waveDataList) {
                if (wd.waveState != WaveData.WaveState.SUSPENDED) continue;
                wd.waveState = WaveData.WaveState.ACTIVE;
                wd.isMuted = false;
            }
        }
    }

    public static void printWDStates(ArrayList<WaveData> waveDataList) {
        StringBuffer sb = new StringBuffer("Audio operators\n");
        int n = 1;
        for (WaveData wd : waveDataList) {
            sb.append("wave " + n++ + " " + wd.waveState.toString() + ", ");
        }
        System.out.println(sb.toString());
    }

    public static boolean getJSONFromFile(File selection, JSONObject json, WaveSynth synth, boolean isStrict) {
        if (selection == null) {
            System.out.println("Window was closed or the user hit cancel.");
            return false;
        }
        json = PApplet.loadJSONObject((File)selection);
        boolean goodHeader = WaveSynthBuilder.checkJSONHeader(json, "PXAU", "WSYN");
        if (goodHeader) {
            System.out.println("--->> JSON file contains WaveSynthEditor data. It should load correctly.");
        } else {
            if (isStrict) {
                System.out.println("--->> JSON file may not contain WaveSynthEditor data. WaveSynth was not initialized.");
                return false;
            }
            System.out.println("--->> JSON file may not contain WaveSynthEditor data. Will try to initialize WaveSynth,anyhow.");
        }
        WaveSynthBuilder.setWaveSynthFromJSON(json, synth);
        return true;
    }

    public static boolean getJSONFromFile(File selection, JSONObject json, WaveSynth synth) {
        return WaveSynthBuilder.getJSONFromFile(selection, json, synth, false);
    }

    public static boolean checkJSONHeader(JSONObject json, String key, String val) {
        String pxau;
        JSONObject header;
        JSONObject jSONObject = header = json.isNull("header") ? null : json.getJSONObject("header");
        if (header != null) {
            pxau = header.isNull(key) ? "" : header.getString(key);
        } else {
            String string = pxau = json.isNull(key) ? "" : json.getString(key);
        }
        return pxau.equals(val);
    }

    public static void setWaveSynthFromJSON(JSONObject json, WaveSynth synth) {
        int animSteps = json.isNull("steps") ? 240 : json.getInt("steps");
        synth.setAnimSteps(animSteps);
        int animStop = json.isNull("stop") ? WaveSynthBuilder.animSteps : json.getInt("stop");
        synth.setStop(animStop);
        float myGamma = json.isNull("gamma") ? 1.0f : json.getFloat("gamma");
        synth.setGamma(myGamma);
        String comments = json.isNull("comments") ? "" : json.getString("comments");
        synth.setComments(comments);
        synth.setGain(json.isNull("blendFactor") ? 0.5f : json.getFloat("blendFactor"));
        synth.setVideoFilename(json.isNull("filename") ? "wavesynth.mp4" : json.getString("filename"));
        synth.setScaleHisto(json.isNull("scaleHisto") ? false : json.getBoolean("scaleHisto"));
        if (synth.isScaleHisto()) {
            synth.setHistoHigh(json.isNull("histoHigh") ? 255 : json.getInt("histoHigh"));
            synth.setHistoLow(json.isNull("histoLow") ? 0 : json.getInt("histoLow"));
        }
        JSONArray waveDataArray = json.getJSONArray("waves");
        int datalen = waveDataArray.size();
        ArrayList<WaveData> waveDataList = new ArrayList<WaveData>(datalen);
        int i = 0;
        while (i < datalen) {
            JSONObject waveElement = waveDataArray.getJSONObject(i);
            float f = waveElement.getFloat("freq");
            float a = waveElement.getFloat("amp");
            float p = waveElement.getFloat("phase");
            float dc = 0.0f;
            if (!waveElement.isNull("dc")) {
                dc = waveElement.getFloat("dc");
            }
            JSONObject rgbColor = waveElement.getJSONObject("color");
            int c = PixelAudioMapper.composeColor(rgbColor.getInt("r"), rgbColor.getInt("g"), rgbColor.getInt("b"));
            float cycles = waveElement.getFloat("cycles");
            WaveData wd = new WaveData(f, a, p, dc, cycles, c, animSteps);
            waveDataList.add(wd);
            ++i;
        }
        synth.setWaveDataList(waveDataList);
        synth.prepareAnimation();
        synth.renderFrame(0);
    }

    public static String waveSynthAsString(WaveSynth synth) {
        Path path = Paths.get(synth.getVideoFilename(), new String[0]);
        StringBuffer sb = new StringBuffer();
        String fname = path.getFileName().toString();
        sb.append("\n--------=====>>> Current WaveSynth instance for file " + fname + " <<<=====--------\n");
        sb.append("Animation steps: " + synth.getAnimSteps());
        sb.append("gain: " + synth.getGain());
        sb.append("gamma: " + synth.getGamma());
        if (synth.isScaleHisto()) {
            sb.append("scaleHisto: " + synth.isScaleHisto());
            sb.append("histoLow: " + synth.getHistoLow());
            sb.append("histoHigh: " + synth.getHistoHigh());
        }
        sb.append(fname);
        sb.append("video filename: " + synth.getVideoFilename());
        int i = 0;
        while (i < synth.waveDataList.size()) {
            WaveData wd = synth.waveDataList.get(i);
            sb.append("  " + (i + 1) + ":: " + wd.toString());
            ++i;
        }
        sb.append("comments: " + synth.getComments() + "\n");
        return sb.toString();
    }

    public static void saveWaveSynthJSON(PApplet app, File selection, WaveSynth synth) {
        if (selection == null) {
            System.out.println("Window was closed or the user hit cancel.");
            return;
        }
        System.out.println("User selected " + selection.getAbsolutePath());
        Object currentFileName = selection.getName().length() < 5 || selection.getName().indexOf(".json") != selection.getName().length() - 5 ? selection.getAbsolutePath() + ".json" : selection.getAbsolutePath();
        JSONArray waveDataArray = new JSONArray();
        int i = 0;
        while (i < synth.waveDataList.size()) {
            WaveData wd = synth.waveDataList.get(i);
            JSONObject waveElement = new JSONObject();
            waveElement.setInt("index", i);
            waveElement.setFloat("freq", wd.freq);
            waveElement.setFloat("amp", wd.amp);
            waveElement.setFloat("phase", wd.phase);
            waveElement.setFloat("phaseInc", wd.phaseInc);
            waveElement.setFloat("cycles", wd.phaseCycles);
            waveElement.setFloat("dc", wd.dc);
            int[] rgb = PixelAudioMapper.rgbComponents(wd.waveColor);
            JSONObject rgbColor = new JSONObject();
            rgbColor.setInt("r", rgb[0]);
            rgbColor.setInt("g", rgb[1]);
            rgbColor.setInt("b", rgb[2]);
            waveElement.setJSONObject("color", rgbColor);
            waveDataArray.append(waveElement);
            ++i;
        }
        JSONObject stateData = new JSONObject();
        stateData.setJSONObject("header", WaveSynthBuilder.getWaveSynthJSONHeader());
        stateData.setInt("steps", synth.animSteps);
        stateData.setInt("stop", synth.getStop());
        stateData.setFloat("blendFactor", synth.gain);
        stateData.setInt("dataFormat", 2);
        stateData.setString("comments", synth.comments);
        Object videoName = synth.videoFilename;
        if (videoName == null || ((String)videoName).equals("")) {
            videoName = selection.getName();
            videoName = ((String)videoName).indexOf(".json") != -1 ? ((String)videoName).substring(0, ((String)videoName).indexOf(".json")) + ".mp4" : (String)videoName + ".mp4";
        }
        System.out.println("----->>> video name is " + (String)videoName);
        synth.videoFilename = videoName;
        stateData.setString("filename", (String)videoName);
        stateData.setFloat("gamma", synth.gamma);
        stateData.setBoolean("scaleHisto", synth.isScaleHisto);
        stateData.setFloat("histoHigh", (float)synth.histoHigh);
        stateData.setFloat("histoLow", (float)synth.histoLow);
        stateData.setJSONArray("waves", waveDataArray);
        app.saveJSONObject(stateData, (String)currentFileName);
    }

    public static JSONObject getWaveSynthJSONHeader() {
        JSONObject header = new JSONObject();
        header.setString("PXAU", "WSYN");
        header.setString("description", "WaveSynthEditor data created with the PixelAudio library by Paul Hertz.");
        header.setString("PixelAudioURL", "https://github.com/Ignotus-mago/PixelAudio");
        return header;
    }
}

