/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.curves;

import java.util.ArrayList;
import java.util.ListIterator;
import net.paulhertz.pixelaudio.curves.PABezVertex;
import net.paulhertz.pixelaudio.curves.PALineVertex;
import net.paulhertz.pixelaudio.curves.PAVertex2DINF;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class PABezShape {
    float x;
    float y;
    private ArrayList<PAVertex2DINF> curves;
    boolean isClosed = false;
    boolean isMarked = false;
    public static final int LINE_SEGMENT = 1;
    public static final int CURVE_SEGMENT = 2;
    boolean hasFill;
    boolean hasStroke;
    int fillColor;
    int strokeColor;
    float weight;
    float[] bounds;
    public static final double KAPPA = 0.5522847498;
    public static final float LAMBDA = 0.3905243f;

    public PABezShape(float x, float y, boolean isClosed) {
        this.setStartPoint(x, y);
        this.curves = new ArrayList();
        this.isClosed = isClosed;
    }

    public float x() {
        return this.x;
    }

    public void setX(float newX) {
        this.x = newX;
    }

    public float y() {
        return this.y;
    }

    public void setY(float newY) {
        this.y = newY;
    }

    public PALineVertex startVertex() {
        return new PALineVertex(this.x, this.y);
    }

    public void setStartPoint(float newX, float newY) {
        this.setX(newX);
        this.setY(newY);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setIsClosed(boolean newIsClosed) {
        this.isClosed = newIsClosed;
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public void setIsMarked(boolean newIsMarked) {
        this.isMarked = newIsMarked;
    }

    public boolean hasFill() {
        return this.hasFill;
    }

    public void setHasFill(boolean newHasFill) {
        this.hasFill = newHasFill;
    }

    public void setNoFill() {
        this.setHasFill(false);
    }

    public boolean hasStroke() {
        return this.hasStroke;
    }

    public void setHasStroke(boolean newHasStroke) {
        this.hasStroke = newHasStroke;
    }

    public void setNoStroke() {
        this.setHasStroke(false);
    }

    public int fillColor() {
        return this.fillColor;
    }

    public void setFillColor(int newFillColor) {
        this.fillColor = newFillColor;
        this.setHasFill(true);
    }

    public int strokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int newStrokeColor) {
        this.strokeColor = newStrokeColor;
        this.setHasStroke(true);
    }

    public void setFillOpacity(int opacity) {
        int[] argb = PABezShape.argbComponents(this.fillColor);
        this.setFillColor(PABezShape.composeColor(argb[1], argb[2], argb[3], opacity));
    }

    public int fillOpacity() {
        int[] argb = PABezShape.argbComponents(this.fillColor);
        return argb[0];
    }

    public void setStrokeOpacity(int opacity) {
        int[] argb = PABezShape.argbComponents(this.strokeColor);
        this.setStrokeColor(PABezShape.composeColor(argb[1], argb[2], argb[3], opacity));
    }

    public int strokeOpacity() {
        int[] argb = PABezShape.argbComponents(this.strokeColor);
        return argb[0];
    }

    public float weight() {
        return this.weight;
    }

    public void setWeight(float newWeight) {
        this.weight = newWeight;
    }

    public static int[] rgbComponents(int rgb) {
        int[] comp = new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF};
        return comp;
    }

    public static int[] argbComponents(int argb) {
        int[] comp = new int[]{argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
        return comp;
    }

    public static int[] rgbaComponents(int argb) {
        int[] comp = new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF};
        return comp;
    }

    public static int composeColor(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static final int composeColor(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int composeColor(int[] comp) {
        return 0xFF000000 | comp[0] << 16 | comp[1] << 8 | comp[2];
    }

    public static int composeColor(int gray) {
        return 0xFF000000 | gray << 16 | gray << 8 | gray;
    }

    public void append(PAVertex2DINF vt) {
        this.curves.add(vt);
    }

    public void append(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        this.append(new PABezVertex(cx1, cy1, cx2, cy2, x, y));
    }

    public void append(float x, float y) {
        this.append(new PALineVertex(x, y));
    }

    public ListIterator<PAVertex2DINF> curveIterator() {
        return this.curves.listIterator();
    }

    public int size() {
        return this.curves.size();
    }

    public int pointCount() {
        int count = 0;
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            if (bez.segmentType() == 2) {
                count += 3;
                continue;
            }
            if (bez.segmentType() != 1) continue;
            ++count;
        }
        return count;
    }

    public PABezShape clone() {
        PABezShape copyThis = new PABezShape(this.x, this.y, false);
        copyThis.setIsClosed(this.isClosed());
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            copyThis.append(bez.clone());
        }
        return copyThis;
    }

    public void drawQuick(PApplet parent) {
        parent.beginShape();
        parent.vertex(this.x, this.y);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        int i = 0;
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            bez.draw(parent);
            if (this.isMarked) {
                if (bez.segmentType() == 2) {
                    parent.pushStyle();
                    parent.noFill();
                    parent.stroke(192);
                    parent.strokeWeight(1.0f);
                    PABezVertex bz = (PABezVertex)bez;
                    if (i > 0) {
                        parent.line(this.curves.get(i - 1).x(), this.curves.get(i - 1).y(), bz.cx1(), bz.cy1());
                        parent.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    } else {
                        int w = 6;
                        parent.pushStyle();
                        parent.noStroke();
                        parent.fill(160);
                        parent.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
                        parent.popStyle();
                        parent.line(this.x, this.y, bz.cx1(), bz.cy1());
                        parent.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    }
                    parent.popStyle();
                }
                bez.mark(parent);
            }
            ++i;
        }
        if (this.isClosed()) {
            parent.endShape(2);
        } else {
            parent.endShape();
        }
    }

    public void drawQuick(PGraphics pg) {
        pg.beginShape();
        pg.vertex(this.x, this.y);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        int i = 0;
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            bez.draw(pg);
            if (this.isMarked) {
                if (bez.segmentType() == 2) {
                    pg.pushStyle();
                    pg.noFill();
                    pg.stroke(192);
                    pg.strokeWeight(1.0f);
                    PABezVertex bz = (PABezVertex)bez;
                    if (i > 0) {
                        pg.line(this.curves.get(i - 1).x(), this.curves.get(i - 1).y(), bz.cx1(), bz.cy1());
                        pg.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    } else {
                        int w = 6;
                        pg.pushStyle();
                        pg.noStroke();
                        pg.fill(160);
                        pg.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
                        pg.popStyle();
                        pg.line(this.x, this.y, bz.cx1(), bz.cy1());
                        pg.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    }
                    pg.popStyle();
                }
                bez.mark(pg);
            }
            ++i;
        }
        if (this.isClosed()) {
            pg.endShape(2);
        } else {
            pg.endShape();
        }
    }

    public void draw(PApplet parent) {
        parent.beginShape();
        if (this.hasFill()) {
            parent.fill(this.fillColor);
        } else {
            parent.noFill();
        }
        if (this.hasStroke()) {
            parent.stroke(this.strokeColor);
        } else {
            parent.noStroke();
        }
        parent.strokeWeight(this.weight);
        parent.vertex(this.x, this.y);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        int i = 0;
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            bez.draw(parent);
            if (this.isMarked) {
                if (bez.segmentType() == 2) {
                    parent.pushStyle();
                    parent.noFill();
                    parent.stroke(192);
                    parent.strokeWeight(1.0f);
                    PABezVertex bz = (PABezVertex)bez;
                    if (i > 0) {
                        parent.line(this.curves.get(i - 1).x(), this.curves.get(i - 1).y(), bz.cx1(), bz.cy1());
                        parent.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    } else {
                        int w = 6;
                        parent.pushStyle();
                        parent.noStroke();
                        parent.fill(160);
                        parent.rect(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w, (float)w);
                        parent.popStyle();
                        parent.line(this.x, this.y, bz.cx1(), bz.cy1());
                        parent.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    }
                    parent.popStyle();
                }
                bez.mark(parent);
            }
            ++i;
        }
        if (this.isClosed()) {
            parent.endShape(2);
        } else {
            parent.endShape();
        }
    }

    public void draw(PGraphics pg) {
        pg.beginShape();
        if (this.hasFill()) {
            pg.fill(this.fillColor);
        } else {
            pg.noFill();
        }
        if (this.hasStroke()) {
            pg.stroke(this.strokeColor);
        } else {
            pg.noStroke();
        }
        pg.strokeWeight(this.weight);
        pg.vertex(this.x, this.y);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        int i = 0;
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            bez.draw(pg);
            if (this.isMarked) {
                if (bez.segmentType() == 2) {
                    pg.pushStyle();
                    pg.noFill();
                    pg.stroke(192);
                    pg.strokeWeight(1.0f);
                    PABezVertex bz = (PABezVertex)bez;
                    if (i > 0) {
                        pg.line(this.curves.get(i - 1).x(), this.curves.get(i - 1).y(), bz.cx1(), bz.cy1());
                        pg.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    } else {
                        int w = 6;
                        pg.pushStyle();
                        pg.noStroke();
                        pg.fill(160);
                        pg.rect(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w, (float)w);
                        pg.popStyle();
                        pg.line(this.x, this.y, bz.cx1(), bz.cy1());
                        pg.line(bz.x(), bz.y(), bz.cx2(), bz.cy2());
                    }
                    pg.popStyle();
                }
                bez.mark(pg);
            }
            ++i;
        }
        if (this.isClosed()) {
            pg.endShape(2);
        } else {
            pg.endShape();
        }
    }

    @Deprecated
    public ArrayList<PVector> getPointList(PApplet parent, int steps) {
        return this.getPointList(steps);
    }

    public ArrayList<PVector> getPointList(int steps) {
        ArrayList<PVector> curvePoints = new ArrayList<PVector>();
        ListIterator<PAVertex2DINF> it = this.curves.listIterator();
        int ct = 1;
        while (it.hasNext()) {
            PAVertex2DINF vt = it.next();
            int segType = vt.segmentType();
            if (2 == segType) {
                ct += steps;
                continue;
            }
            if (1 != segType) continue;
            ++ct;
        }
        float[] points = new float[ct * 2];
        int i = 0;
        points[i++] = this.x;
        points[i++] = this.y;
        float currentX = points[i - 2];
        float currentY = points[i - 1];
        it = this.curves.listIterator();
        while (it.hasNext()) {
            PAVertex2DINF vt = it.next();
            int segType = vt.segmentType();
            if (2 == segType) {
                float[] knots = vt.coords();
                float cx1 = knots[0];
                float cy1 = knots[1];
                float cx2 = knots[2];
                float cy2 = knots[3];
                float ax = knots[4];
                float ay = knots[5];
                int j = 1;
                while (j <= steps) {
                    float t = (float)j / (float)steps;
                    float segx = this.bezierPoint(currentX, cx1, cx2, ax, t);
                    float segy = this.bezierPoint(currentY, cy1, cy2, ay, t);
                    points[i++] = segx;
                    points[i++] = segy;
                    ++j;
                }
            } else if (1 == segType) {
                points[i++] = vt.x();
                points[i++] = vt.y();
            }
            currentX = points[i - 2];
            currentY = points[i - 1];
        }
        int j = 0;
        while (j < i) {
            curvePoints.add(new PVector(points[j++], points[j++]));
        }
        return curvePoints;
    }

    @Deprecated
    public ArrayList<PVector> getPointList(PGraphics pg, int steps) {
        return this.getPointList(steps);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        float t1 = 1.0f - t;
        return (a * t1 + 3.0f * b * t) * t1 * t1 + (3.0f * c * t1 + d * t) * t * t;
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return 3.0f * t * t * (-a + 3.0f * b - 3.0f * c + d) + 6.0f * t * (a - 2.0f * b + c) + 3.0f * (-a + b);
    }

    protected float[] bounds() {
        ArrayList<PVector> points = this.getPointList(16);
        PVector vec = points.get(0);
        float xMin = vec.x;
        float yMin = vec.y;
        float xMax = xMin;
        float yMax = yMin;
        int i = 1;
        while (i < points.size()) {
            vec = points.get(i);
            float x = vec.x;
            float y = vec.y;
            if (x < xMin) {
                xMin = x;
            }
            if (y < yMin) {
                yMin = y;
            }
            if (x > xMax) {
                xMax = x;
            }
            if (y > yMax) {
                yMax = y;
            }
            ++i;
        }
        float[] result = new float[]{xMin, yMin, xMax, yMax};
        return result;
    }

    public float[] getBounds() {
        if (this.bounds == null) {
            this.bounds = this.bounds();
        }
        return this.bounds;
    }

    public void setBounds(float[] newBounds) {
        this.bounds = newBounds;
    }

    public PVector getBoundsCenter() {
        float[] bounds = this.getBounds();
        float left = bounds[0];
        float top = bounds[1];
        float right = bounds[2];
        float bottom = bounds[3];
        return new PVector((right + left) / 2.0f, (top + bottom) / 2.0f);
    }

    public void translateShape(float xTrans, float yTrans) {
        this.setStartPoint(this.x + xTrans, this.y + yTrans);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        while (it.hasNext()) {
            PAVertex2DINF vt = it.next();
            int segType = vt.segmentType();
            if (2 == segType) {
                PABezVertex bv = (PABezVertex)vt;
                float[] coords = bv.coords();
                coords[0] = coords[0] + xTrans;
                coords[1] = coords[1] + yTrans;
                coords[2] = coords[2] + xTrans;
                coords[3] = coords[3] + yTrans;
                coords[4] = coords[4] + xTrans;
                coords[5] = coords[5] + yTrans;
                bv.setCx1(coords[0]);
                bv.setCy1(coords[1]);
                bv.setCx2(coords[2]);
                bv.setCy2(coords[3]);
                bv.setX(coords[4]);
                bv.setY(coords[5]);
                continue;
            }
            if (1 != segType) continue;
            PALineVertex lv = (PALineVertex)vt;
            lv.setX(lv.x + xTrans);
            lv.setY(lv.y + yTrans);
        }
        this.bounds = null;
    }

    public void scaleShape(float xScale, float yScale, float x0, float y0) {
        this.x = x0 + (this.x - x0) * xScale;
        this.y = y0 + (this.y - y0) * yScale;
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        while (it.hasNext()) {
            PVector pt;
            PAVertex2DINF vt = it.next();
            int segType = vt.segmentType();
            float[] coords = vt.coords();
            if (2 == segType) {
                PABezVertex bv = (PABezVertex)vt;
                pt = PABezShape.scaleCoordAroundPoint(coords[0], coords[1], xScale, yScale, x0, y0);
                bv.setCx1(pt.x);
                bv.setCy1(pt.y);
                pt = PABezShape.scaleCoordAroundPoint(coords[2], coords[3], xScale, yScale, x0, y0);
                bv.setCx2(pt.x);
                bv.setCy2(pt.y);
                pt = PABezShape.scaleCoordAroundPoint(coords[4], coords[5], xScale, yScale, x0, y0);
                bv.setX(pt.x);
                bv.setY(pt.y);
                continue;
            }
            if (1 != segType) continue;
            PALineVertex lv = (PALineVertex)vt;
            pt = PABezShape.scaleCoordAroundPoint(coords[0], coords[1], xScale, yScale, x0, y0);
            lv.setX(pt.x);
            lv.setY(pt.y);
        }
        this.bounds = null;
    }

    public void rotateShape(float xctr, float yctr, float theta) {
        PVector pt = PABezShape.rotateCoordAroundPoint(this.x(), this.y(), xctr, yctr, theta);
        this.setX(pt.x);
        this.setY(pt.y);
        ListIterator<PAVertex2DINF> it = this.curveIterator();
        while (it.hasNext()) {
            PAVertex2DINF vt = it.next();
            int segType = vt.segmentType();
            float[] coords = vt.coords();
            if (2 == segType) {
                PABezVertex bv = (PABezVertex)vt;
                pt = PABezShape.rotateCoordAroundPoint(coords[0], coords[1], xctr, yctr, theta);
                bv.setCx1(pt.x);
                bv.setCy1(pt.y);
                pt = PABezShape.rotateCoordAroundPoint(coords[2], coords[3], xctr, yctr, theta);
                bv.setCx2(pt.x);
                bv.setCy2(pt.y);
                pt = PABezShape.rotateCoordAroundPoint(coords[4], coords[5], xctr, yctr, theta);
                bv.setX(pt.x);
                bv.setY(pt.y);
                continue;
            }
            if (1 != segType) continue;
            PALineVertex lv = (PALineVertex)vt;
            pt = PABezShape.rotateCoordAroundPoint(coords[0], coords[1], xctr, yctr, theta);
            lv.setX(pt.x);
            lv.setY(pt.y);
        }
        this.bounds = null;
    }

    public static PVector translateCoord(float x, float y, float xOffset, float yOffset) {
        return new PVector(x + xOffset, y + yOffset);
    }

    public static PVector scaleCoordAroundPoint(float x, float y, float xScale, float yScale, float xctr, float yctr) {
        float xout = xctr + (x - xctr) * xScale;
        float yout = yctr + (y - yctr) * yScale;
        return new PVector(xout, yout);
    }

    public static PVector rotateCoordAroundPoint(float x, float y, float xctr, float yctr, float theta) {
        double sintheta = Math.sin(theta);
        double costheta = Math.cos(theta);
        PVector pt = PABezShape.translateCoord(x, y, -xctr, -yctr);
        pt.set((float)((double)pt.x * costheta - (double)pt.y * sintheta), (float)((double)pt.x * sintheta + (double)pt.y * costheta));
        return PABezShape.translateCoord(pt.x, pt.y, xctr, yctr);
    }

    public static boolean pointInPoly(ArrayList<PVector> poly, float x, float y) {
        int npol = poly.size();
        int j = 0;
        boolean inside = false;
        int i = 0;
        j = npol - 1;
        while (i < npol) {
            PVector iVec = poly.get(i);
            PVector jVec = poly.get(j);
            if ((iVec.y <= y && y < jVec.y || jVec.y <= y && y < iVec.y) && x < (jVec.x - iVec.x) * (y - iVec.y) / (jVec.y - iVec.y) + iVec.x) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }
}

