/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.curves;

import net.paulhertz.pixelaudio.curves.PAVertex2DINF;
import processing.core.PApplet;
import processing.core.PGraphics;

public class PABezVertex
implements PAVertex2DINF {
    protected float cx1;
    protected float cy1;
    protected float cx2;
    protected float cy2;
    protected float x;
    protected float y;
    public static final int segmentType = 2;

    public PABezVertex(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        this.cx1 = cx1;
        this.cy1 = cy1;
        this.cx2 = cx2;
        this.cy2 = cy2;
        this.x = x;
        this.y = y;
    }

    public PABezVertex() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public float cx1() {
        return this.cx1;
    }

    public void setCx1(float newCx1) {
        this.cx1 = newCx1;
    }

    public float cy1() {
        return this.cy1;
    }

    public void setCy1(float newCy1) {
        this.cy1 = newCy1;
    }

    public float cx2() {
        return this.cx2;
    }

    public void setCx2(float newCx2) {
        this.cx2 = newCx2;
    }

    public float cy2() {
        return this.cy2;
    }

    public void setCy2(float newCy2) {
        this.cy2 = newCy2;
    }

    @Override
    public float x() {
        return this.x;
    }

    public void setX(float newX) {
        this.x = newX;
    }

    @Override
    public float y() {
        return this.y;
    }

    public void setY(float newY) {
        this.y = newY;
    }

    @Override
    public int segmentType() {
        return 2;
    }

    @Override
    public float[] coords() {
        float[] knots = new float[]{this.cx1, this.cy1, this.cx2, this.cy2, this.x, this.y};
        return knots;
    }

    @Override
    public PABezVertex clone() {
        return new PABezVertex(this.cx1, this.cy1, this.cx2, this.cy2, this.x, this.y);
    }

    @Override
    public void draw(PApplet parent) {
        parent.bezierVertex(this.cx1, this.cy1, this.cx2, this.cy2, this.x, this.y);
    }

    @Override
    public void draw(PGraphics pg) {
        pg.bezierVertex(this.cx1, this.cy1, this.cx2, this.cy2, this.x, this.y);
    }

    @Override
    public void mark(PApplet parent) {
        int w = 6;
        int d = w - 1;
        parent.pushStyle();
        parent.noStroke();
        parent.fill(192);
        parent.ellipse(this.cx1, this.cy1, (float)d, (float)d);
        parent.ellipse(this.cx2, this.cy2, (float)d, (float)d);
        parent.fill(160);
        parent.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
        parent.popStyle();
    }

    @Override
    public void mark(PGraphics pg) {
        int w = 6;
        int d = w - 1;
        pg.pushStyle();
        pg.noStroke();
        pg.fill(192);
        pg.ellipse(this.cx1, this.cy1, (float)d, (float)d);
        pg.ellipse(this.cx2, this.cy2, (float)d, (float)d);
        pg.fill(160);
        pg.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
        pg.popStyle();
    }
}

