/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.curves;

import java.util.ArrayList;
import net.paulhertz.pixelaudio.curves.PABezShape;
import net.paulhertz.pixelaudio.curves.PACurveUtility;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class PACurveMaker {
    public ArrayList<PVector> dragPoints;
    private ArrayList<PVector> rdpPoints;
    private ArrayList<Integer> rdpIndices;
    private PABezShape curveShape;
    private PABezShape brushShape;
    private ArrayList<PVector> brushPoly;
    public int polySteps = 8;
    public float brushSize = 24.0f;
    public float epsilon = 8.0f;
    public boolean isDrawWeighted = false;
    public float bezierBias = 0.3905243f;
    public int dragColor = PABezShape.composeColor(233, 199, 89, 128);
    public float dragWeight = 8.0f;
    public int rdpColor = PABezShape.composeColor(233, 89, 144);
    public float rdpWeight = 2.0f;
    public int curveColor = PABezShape.composeColor(55, 199, 246);
    public float curveWeight = 4.0f;
    public int brushColor = PABezShape.composeColor(76, 199, 144, 96);
    public int activeBrushColor = PABezShape.composeColor(199, 89, 55, 192);
    public float brushWeight = 0.0f;
    private ArrayList<PVector> eventPoints;
    public int eventSteps = 8;
    public int eventPointsColor = PABezShape.composeColor(233, 199, 144, 192);
    public float eventPointsSize = 8.0f;
    private boolean isReady = false;
    public int timeStamp;
    public int timeOffset;
    ArrayList<Integer> dragTimes;

    private PACurveMaker(ArrayList<PVector> points) {
        this.dragPoints = new ArrayList<PVector>(points);
        this.rdpPoints = new ArrayList();
        this.rdpIndices = new ArrayList();
    }

    public void setDrawingProperties(int dragColor, float dragWeight, int rdpColor, float rdpWeight, int curveColor, float curveWeight, int brushColor, float brushWeight, int activeBrushColor) {
        this.dragColor = dragColor;
        this.dragWeight = dragWeight;
        this.rdpColor = rdpColor;
        this.rdpWeight = rdpWeight;
        this.curveColor = curveColor;
        this.curveWeight = curveWeight;
        this.brushColor = brushColor;
        this.brushWeight = brushWeight;
        this.activeBrushColor = activeBrushColor;
    }

    public static PACurveMaker buildCurveMaker(ArrayList<PVector> points) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        return curveMaker;
    }

    public static PACurveMaker buildCurveMaker(ArrayList<PVector> points, float epsilon) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        curveMaker.setEpsilon(epsilon);
        return curveMaker;
    }

    public static PACurveMaker buildCurveMaker(ArrayList<PVector> points, float epsilon, int dragColor, float dragWeight, int rdpColor, float rdpWeight, int curveColor, float curveWeight, int brushColor, float brushWeight, int activeBrushColor) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        curveMaker.setEpsilon(epsilon);
        curveMaker.setDrawingProperties(dragColor, dragWeight, rdpColor, rdpWeight, curveColor, curveWeight, brushColor, brushWeight, activeBrushColor);
        return curveMaker;
    }

    public static PACurveMaker buildCurveMakerComplete(ArrayList<PVector> points) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        curveMaker.calculateDerivedPoints();
        return curveMaker;
    }

    public static PACurveMaker buildCurveMakerComplete(ArrayList<PVector> points, float epsilon) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        curveMaker.setEpsilon(epsilon);
        curveMaker.calculateDerivedPoints();
        return curveMaker;
    }

    public static PACurveMaker buildCurveMakerComplete(ArrayList<PVector> points, float epsilon, int dragColor, float dragWeight, int rdpColor, float rdpWeight, int curveColor, float curveWeight, int brushColor, float brushWeight, int activeBrushColor) {
        PACurveMaker curveMaker = new PACurveMaker(points);
        curveMaker.setEpsilon(epsilon);
        curveMaker.setDrawingProperties(dragColor, dragWeight, rdpColor, rdpWeight, curveColor, curveWeight, brushColor, brushWeight, activeBrushColor);
        curveMaker.calculateDerivedPoints();
        return curveMaker;
    }

    public void reducePoints(float epsilon) {
        this.rdpPoints.clear();
        this.rdpIndices.clear();
        int total = this.dragPoints.size();
        PVector start = this.dragPoints.get(0);
        PVector end = this.dragPoints.get(total - 1);
        this.rdpPoints.add(start);
        this.rdpIndices.add(0);
        PACurveUtility.indexedRDP(0, total - 1, this.dragPoints, this.rdpPoints, this.rdpIndices, epsilon);
        if (this.rdpPoints.size() == 1) {
            PVector midPoint = start.copy().add(end).div(2.0f);
            this.rdpPoints.add(midPoint);
        }
        this.rdpPoints.add(end);
        this.rdpIndices.add(total - 1);
    }

    public void calculateDerivedPoints() {
        this.reducePoints(this.epsilon);
        this.curveShape = this.getCurveShape();
        this.eventPoints = this.curveShape.getPointList(this.polySteps);
        this.brushShape = this.getBrushShape();
        this.brushShape.setNoStroke();
        this.brushShape.setFillColor(this.brushColor);
        this.brushPoly = this.brushShape.getPointList(this.polySteps);
        this.isReady = true;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isDrawWeighted() {
        return this.isDrawWeighted;
    }

    public void setDrawWeighted(boolean isDrawWeighted) {
        this.isDrawWeighted = isDrawWeighted;
    }

    public float getBrushSize() {
        return this.brushSize;
    }

    public void setBrushSize(float brushSize) {
        this.brushSize = brushSize;
    }

    public float getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(float epsilon) {
        this.epsilon = Math.abs(epsilon);
        if (epsilon < 1.0f) {
            epsilon = 1.0f;
        }
        this.epsilon = epsilon;
    }

    public float getBezierBias() {
        return this.bezierBias;
    }

    public void setBezierBias(float bias) {
        this.bezierBias = bias;
    }

    public ArrayList<PVector> getDragPoints() {
        return this.dragPoints;
    }

    public void setDragPoints(ArrayList<PVector> dragPoints) {
        this.dragPoints = dragPoints;
    }

    public int getDragColor() {
        return this.dragColor;
    }

    public void setDragColor(int dragColor) {
        this.dragColor = dragColor;
    }

    public float getDragWeight() {
        return this.dragWeight;
    }

    public void setDragWeight(float dragWeight) {
        this.dragWeight = dragWeight;
    }

    public ArrayList<PVector> getRdpPoints() {
        if (this.rdpPoints.size() < 1) {
            this.reducePoints(this.epsilon);
        }
        return this.rdpPoints;
    }

    public void setRdpPoints(ArrayList<PVector> rdpPoints) {
        this.rdpPoints = rdpPoints;
    }

    public ArrayList<Integer> getRdpIndices() {
        return this.rdpIndices;
    }

    public int[] getRdpIndicesAsInts() {
        int[] inds = this.rdpIndices.stream().mapToInt(Integer::intValue).toArray();
        return inds;
    }

    public void setRdpIndices(ArrayList<Integer> rdpIndices) {
        this.rdpIndices = rdpIndices;
    }

    public int getRdpColor() {
        return this.rdpColor;
    }

    public void setRdpColor(int rdpColor) {
        this.rdpColor = rdpColor;
    }

    public float getRdpWeight() {
        return this.rdpWeight;
    }

    public void setRdpWeight(float rdpWeight) {
        this.rdpWeight = rdpWeight;
    }

    public PABezShape getCurveShape() {
        if (this.curveShape == null) {
            this.curveShape = this.isDrawWeighted ? PACurveUtility.calculateWeightedCurve(this.getRdpPoints(), this.bezierBias) : PACurveUtility.calculateCurve(this.getRdpPoints());
        }
        return this.curveShape;
    }

    public PABezShape getWeightedCurveShape(float bias) {
        return PACurveUtility.calculateWeightedCurve(this.getRdpPoints(), bias);
    }

    public PABezShape getWeightedCurveShape() {
        return PACurveUtility.calculateWeightedCurve(this.getRdpPoints(), this.bezierBias);
    }

    public void setCurveShape(PABezShape curveShape) {
        this.curveShape = curveShape;
    }

    public int getCurveColor() {
        return this.curveColor;
    }

    public void setCurveColor(int curveColor) {
        this.curveColor = curveColor;
    }

    public float getCurveWeight() {
        return this.curveWeight;
    }

    public void setCurveWeight(float curveWeight) {
        this.curveWeight = curveWeight;
    }

    public PABezShape getBrushShape() {
        if (this.brushShape == null) {
            this.brushShape = this.isDrawWeighted ? PACurveUtility.quickBrushShape(this.getRdpPoints(), this.brushSize, true, this.bezierBias) : PACurveUtility.quickBrushShape(this.getRdpPoints(), this.brushSize);
            this.brushShape.setNoStroke();
            this.brushShape.setFillColor(this.brushColor);
        }
        return this.brushShape;
    }

    public PABezShape getWeightedBrushShape() {
        PABezShape weightedBrushShape = PACurveUtility.calculateWeightedCurve(this.getBrushShape(), this.bezierBias);
        return weightedBrushShape;
    }

    public PABezShape getWeightedBrushShape(float brushSize, float bias) {
        PABezShape weightedBrushShape = PACurveUtility.calculateWeightedCurve(this.getBrushShape(), bias);
        return weightedBrushShape;
    }

    public void setBrushShape(PABezShape brushShape) {
        this.brushShape = brushShape;
    }

    public int getBrushColor() {
        return this.brushColor;
    }

    public void setBrushColor(int brushColor) {
        this.brushColor = brushColor;
    }

    public float getBrushWeight() {
        return this.brushWeight;
    }

    public void setBrushWeight(float brushWeight) {
        this.brushWeight = brushWeight;
    }

    public int getActiveBrushColor() {
        return this.activeBrushColor;
    }

    public void setActiveBrushColor(int activeBrushColor) {
        this.activeBrushColor = activeBrushColor;
    }

    public ArrayList<PVector> getBrushPoly() {
        if (this.brushPoly == null) {
            this.brushPoly = this.getBrushShape().getPointList(this.polySteps);
        }
        return this.brushPoly;
    }

    public int getPolySteps() {
        return this.polySteps;
    }

    public void setPolySteps(int polySteps) {
        this.polySteps = polySteps;
    }

    public ArrayList<PVector> getEventPoints() {
        if (this.eventPoints == null) {
            this.eventPoints = this.getCurveShape().getPointList(this.eventSteps);
        }
        return this.eventPoints;
    }

    public ArrayList<PVector> getEventPoints(int eventSteps) {
        return this.getCurveShape().getPointList(eventSteps);
    }

    public void setEventPoints(ArrayList<PVector> eventPoints) {
        this.eventPoints = eventPoints;
    }

    public int getEventSteps() {
        return this.eventSteps;
    }

    public void setEventSteps(int eventSteps) {
        this.eventSteps = eventSteps;
    }

    public int getEventPointsColor() {
        return this.eventPointsColor;
    }

    public void setEventPointsColor(int eventPointsColor) {
        this.eventPointsColor = eventPointsColor;
    }

    public float getEventPointsSize() {
        return this.eventPointsSize;
    }

    public void setEventPointsSize(float eventPointsSize) {
        this.eventPointsSize = eventPointsSize;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(int timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public ArrayList<Integer> getDragTimes() {
        return this.dragTimes;
    }

    public int[] getDragTimesAsInts() {
        int[] times = this.dragTimes.stream().mapToInt(Integer::intValue).toArray();
        return times;
    }

    public void setDragTimes(ArrayList<Integer> dragTimes) {
        this.dragTimes = dragTimes;
    }

    public void dragPointsDraw(PApplet parent, int dragColor, float dragWeight) {
        PACurveUtility.lineDraw(parent, this.dragPoints, dragColor, dragWeight);
    }

    public void dragPointsDraw(PApplet parent) {
        PACurveUtility.lineDraw(parent, this.dragPoints, this.dragColor, this.dragWeight);
    }

    public void reducedPointsDraw(PApplet parent, int rdpColor, float drawWeight) {
        PACurveUtility.lineDraw(parent, this.getRdpPoints(), rdpColor, drawWeight);
    }

    public void reducedPointsDraw(PApplet parent) {
        PACurveUtility.lineDraw(parent, this.getRdpPoints(), this.rdpColor, this.rdpWeight);
    }

    public void dragPointsDraw(PGraphics pg, int dragColor, float dragWeight) {
        PACurveUtility.lineDraw(pg, this.dragPoints, dragColor, dragWeight);
    }

    public void dragPointsDraw(PGraphics pg) {
        PACurveUtility.lineDraw(pg, this.dragPoints, this.dragColor, this.dragWeight);
    }

    public void reducedPointsDraw(PGraphics pg, int rdpColor, float rdpWeight) {
        PACurveUtility.lineDraw(pg, this.getRdpPoints(), rdpColor, rdpWeight);
    }

    public void reducedPointsDraw(PGraphics pg) {
        PACurveUtility.lineDraw(pg, this.getRdpPoints(), this.rdpColor, this.rdpWeight);
    }

    public void curveDraw(PApplet parent) {
        PACurveUtility.curveDraw(parent, this.getCurveShape(), this.curveColor, this.curveWeight);
    }

    public void curveDrawDirect(PApplet parent) {
        PACurveUtility.curveDraw(parent, this.getCurveShape());
    }

    public void curveDraw(PGraphics pg) {
        PACurveUtility.curveDraw(pg, this.getCurveShape(), this.curveColor, this.curveWeight);
    }

    public void curveDrawDirect(PGraphics pg) {
        PACurveUtility.curveDraw(pg, this.getCurveShape());
    }

    public void brushDraw(PApplet parent, int brushColor, int strokeColor, float brushWeight) {
        PACurveUtility.shapeDraw(parent, this.getBrushShape(), brushColor, strokeColor, brushWeight);
    }

    public void brushDraw(PApplet parent) {
        PACurveUtility.shapeDraw(parent, this.getBrushShape(), this.brushColor, this.brushColor, this.brushWeight);
    }

    public void brushDrawDirect(PApplet parent) {
        PACurveUtility.shapeDraw(parent, this.getBrushShape());
    }

    public void brushDraw(PGraphics pg, int brushColor, int strokeColor, float brushWeight) {
        PACurveUtility.shapeDraw(pg, this.getBrushShape(), brushColor, strokeColor, brushWeight);
    }

    public void brushDraw(PGraphics pg) {
        PACurveUtility.shapeDraw(pg, this.getBrushShape(), this.brushColor, this.brushColor, this.brushWeight);
    }

    public void brushDrawDirect(PGraphics pg) {
        PACurveUtility.shapeDraw(pg, this.getBrushShape());
    }

    public void eventPointsDraw(PApplet parent) {
        if (this.eventPoints == null) {
            this.getEventPoints();
        }
        parent.pushStyle();
        parent.noStroke();
        parent.fill(this.eventPointsColor);
        for (PVector v : this.eventPoints) {
            parent.circle(v.x, v.y, this.eventPointsSize);
        }
        parent.popStyle();
    }

    public void eventPointsDraw(PApplet parent, int eventPointsColor, float eventPointsSize) {
        if (this.eventPoints == null) {
            this.getEventPoints();
        }
        parent.pushStyle();
        parent.noStroke();
        parent.fill(eventPointsColor);
        for (PVector v : this.eventPoints) {
            parent.circle(v.x, v.y, eventPointsSize);
        }
        parent.popStyle();
    }

    public void eventPointsDraw(PApplet parent, int eventSteps, int eventPointsColor, float eventPointsSize) {
        if (this.eventPoints == null) {
            this.getEventPoints(eventSteps);
        }
        parent.pushStyle();
        parent.noStroke();
        parent.fill(eventPointsColor);
        for (PVector v : this.eventPoints) {
            parent.circle(v.x, v.y, eventPointsSize);
        }
        parent.popStyle();
    }

    public void eventPointsDraw(PGraphics pg) {
        if (this.eventPoints == null) {
            this.getEventPoints();
        }
        pg.pushStyle();
        pg.noStroke();
        pg.fill(this.eventPointsColor);
        for (PVector v : this.eventPoints) {
            pg.circle(v.x, v.y, this.eventPointsSize);
        }
        pg.popStyle();
    }

    public void eventPointsDraw(PGraphics pg, int eventPointsColor, float eventPointsSize) {
        if (this.eventPoints == null) {
            this.getEventPoints();
        }
        pg.pushStyle();
        pg.noStroke();
        pg.fill(eventPointsColor);
        for (PVector v : this.eventPoints) {
            pg.circle(v.x, v.y, eventPointsSize);
        }
        pg.popStyle();
    }

    public void eventPointsDraw(PGraphics pg, int eventSteps, int eventPointsColor, float eventPointsSize) {
        if (this.eventPoints == null) {
            this.getEventPoints(eventSteps);
        }
        pg.pushStyle();
        pg.noStroke();
        pg.fill(eventPointsColor);
        for (PVector v : this.eventPoints) {
            pg.circle(v.x, v.y, eventPointsSize);
        }
        pg.popStyle();
    }
}

