/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.curves;

import java.util.ArrayList;
import java.util.ListIterator;
import net.paulhertz.pixelaudio.curves.PABezShape;
import net.paulhertz.pixelaudio.curves.PABezVertex;
import net.paulhertz.pixelaudio.curves.PAVertex2DINF;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class PACurveUtility {
    public static void rdp(int startIndex, int endIndex, ArrayList<PVector> allPoints, ArrayList<PVector> rdpPoints, float epsilon) {
        int nextIndex = PACurveUtility.findFurthest(allPoints, startIndex, endIndex, epsilon);
        if (nextIndex > 0) {
            if (startIndex != nextIndex) {
                PACurveUtility.rdp(startIndex, nextIndex, allPoints, rdpPoints, epsilon);
            }
            rdpPoints.add(allPoints.get(nextIndex));
            if (endIndex != nextIndex) {
                PACurveUtility.rdp(nextIndex, endIndex, allPoints, rdpPoints, epsilon);
            }
        }
    }

    public static void indexedRDP(int startIndex, int endIndex, ArrayList<PVector> allPoints, ArrayList<PVector> rdpPoints, ArrayList<Integer> rdpIndices, float epsilon) {
        int nextIndex = PACurveUtility.findFurthest(allPoints, startIndex, endIndex, epsilon);
        if (nextIndex > 0) {
            if (startIndex != nextIndex) {
                PACurveUtility.indexedRDP(startIndex, nextIndex, allPoints, rdpPoints, rdpIndices, epsilon);
            }
            rdpPoints.add(allPoints.get(nextIndex));
            rdpIndices.add(nextIndex);
            if (endIndex != nextIndex) {
                PACurveUtility.indexedRDP(nextIndex, endIndex, allPoints, rdpPoints, rdpIndices, epsilon);
            }
        }
    }

    static int findFurthest(ArrayList<PVector> points, int a, int b, float epsilon) {
        float recordDistance = -1.0f;
        PVector start = points.get(a);
        PVector end = points.get(b);
        int furthestIndex = -1;
        int i = a + 1;
        while (i < b) {
            PVector currentPoint = points.get(i);
            float d = PACurveUtility.lineDist(currentPoint, start, end);
            if (d > recordDistance) {
                recordDistance = d;
                furthestIndex = i;
            }
            ++i;
        }
        if (recordDistance > epsilon) {
            return furthestIndex;
        }
        return -1;
    }

    static float lineDist(PVector c, PVector a, PVector b) {
        PVector norm = PACurveUtility.scalarProjection(c, a, b);
        return PVector.dist((PVector)c, (PVector)norm);
    }

    static PVector scalarProjection(PVector p, PVector a, PVector b) {
        PVector ap = PVector.sub((PVector)p, (PVector)a);
        PVector ab = PVector.sub((PVector)b, (PVector)a);
        ab.normalize();
        ab.mult(ap.dot(ab));
        PVector normalPoint = PVector.add((PVector)a, (PVector)ab);
        return normalPoint;
    }

    public static PABezShape calculateCurve(ArrayList<PVector> framePoints) {
        int n = framePoints.size();
        float[] xCoords = new float[n];
        float[] yCoords = new float[n];
        int i = 0;
        for (PVector vec : framePoints) {
            xCoords[i] = vec.x;
            yCoords[i] = vec.y;
            ++i;
        }
        float[] xp1 = new float[n - 1];
        float[] xp2 = new float[n - 1];
        PACurveUtility.computeControlPoints(xCoords, xp1, xp2);
        float[] yp1 = new float[n - 1];
        float[] yp2 = new float[n - 1];
        PACurveUtility.computeControlPoints(yCoords, yp1, yp2);
        PABezShape bez = new PABezShape(framePoints.get((int)0).x, framePoints.get((int)0).y, false);
        int k = 0;
        while (k < n - 1) {
            bez.append(xp1[k], yp1[k], xp2[k], yp2[k], framePoints.get((int)(k + 1)).x, framePoints.get((int)(k + 1)).y);
            ++k;
        }
        return bez;
    }

    static void computeControlPoints(float[] K, float[] p1, float[] p2) {
        int n = K.length - 1;
        if (n <= 0) {
            return;
        }
        float[] a = new float[n];
        float[] b = new float[n];
        float[] c = new float[n];
        float[] r = new float[n];
        a[0] = 0.0f;
        b[0] = 2.0f;
        c[0] = 1.0f;
        r[0] = K[0] + 2.0f * K[1];
        int i = 1;
        while (i < n - 1) {
            a[i] = 1.0f;
            b[i] = 4.0f;
            c[i] = 1.0f;
            r[i] = 4.0f * K[i] + 2.0f * K[i + 1];
            ++i;
        }
        a[n - 1] = 2.0f;
        b[n - 1] = 7.0f;
        c[n - 1] = 0.0f;
        r[n - 1] = 8.0f * K[n - 1] + K[n];
        i = 1;
        while (i < n) {
            float m = a[i] / b[i - 1];
            b[i] = b[i] - m * c[i - 1];
            r[i] = r[i] - m * r[i - 1];
            ++i;
        }
        p1[n - 1] = r[n - 1] / b[n - 1];
        i = n - 2;
        while (i >= 0) {
            p1[i] = (r[i] - c[i] * p1[i + 1]) / b[i];
            --i;
        }
        i = 0;
        while (i < n - 1) {
            p2[i] = 2.0f * K[i + 1] - p1[i + 1];
            ++i;
        }
        p2[n - 1] = 0.5f * (K[n] + p1[n - 1]);
    }

    public static PABezShape calculateWeightedCurve(PABezShape bezPoints, float bias) {
        PABezShape weightedBezPoints = bezPoints.clone();
        ListIterator<PAVertex2DINF> it = weightedBezPoints.curveIterator();
        float x1 = weightedBezPoints.startVertex().x();
        float y1 = weightedBezPoints.startVertex().y();
        while (it.hasNext()) {
            PAVertex2DINF bez = it.next();
            if (bez.segmentType() == 2) {
                PABezVertex bz = (PABezVertex)bez;
                float d = PApplet.dist((float)x1, (float)y1, (float)bz.x(), (float)bz.y());
                PVector cxy1 = PACurveUtility.weightedControlVec(x1, y1, bz.cx1(), bz.cy1(), bias, d);
                bz.setCx1(cxy1.x);
                bz.setCy1(cxy1.y);
                PVector cxy2 = PACurveUtility.weightedControlVec(bz.x(), bz.y(), bz.cx2(), bz.cy2(), bias, d);
                bz.setCx2(cxy2.x);
                bz.setCy2(cxy2.y);
                x1 = bz.x();
                y1 = bz.y();
                continue;
            }
            if (bez.segmentType() != 1) continue;
            x1 = bez.x();
            y1 = bez.y();
        }
        return weightedBezPoints;
    }

    public static PABezShape calculateWeightedCurve(ArrayList<PVector> framePoints, float bias) {
        PABezShape curve = PACurveUtility.calculateCurve(framePoints);
        return PACurveUtility.calculateWeightedCurve(curve, bias);
    }

    public static void calculateWeightedCurve(PABezShape bezPoints) {
        PACurveUtility.calculateWeightedCurve(bezPoints, 0.3905243f);
    }

    public static PVector weightedControlVec(float ax, float ay, float cx, float cy, float w, float d) {
        float t = w * d * 1.0f / PApplet.dist((float)ax, (float)ay, (float)cx, (float)cy);
        float x = ax + (cx - ax) * t;
        float y = ay + (cy - ay) * t;
        return new PVector(x, y);
    }

    public static PABezShape quickBrushShape(ArrayList<PVector> points, float brushWidth, boolean isDrawWeighted, float bias) {
        ArrayList<PVector> pointsLeft = new ArrayList<PVector>();
        ArrayList<PVector> pointsRight = new ArrayList<PVector>();
        if (points.size() <= 0) {
            return null;
        }
        PVector v1 = points.get(0);
        pointsLeft.add(v1.copy());
        pointsRight.add(v1.copy());
        int i = 1;
        while (i < points.size() - 1) {
            PVector v2 = points.get(i);
            PVector v3 = points.get(i + 1);
            PVector norm1 = PACurveUtility.normalAtPoint(v1, v2, 1.0f, 1.0f);
            PVector norm2 = PACurveUtility.normalAtPoint(v2, v3, 0.0f, 1.0f);
            norm1.add(norm2).mult(0.5f);
            norm1.sub(v2).normalize();
            pointsLeft.add(PACurveUtility.scaledNormalAtPoint(v2, norm1, -brushWidth / 2.0f));
            pointsRight.add(PACurveUtility.scaledNormalAtPoint(v2, norm1, brushWidth / 2.0f));
            v1 = v2;
            ++i;
        }
        v1 = points.get(points.size() - 1);
        pointsLeft.add(v1.copy());
        pointsRight.add(v1.copy());
        PACurveUtility.reverseArray(pointsLeft, 0, pointsLeft.size() - 1);
        PABezShape bezLeft = PACurveUtility.calculateCurve(pointsLeft);
        PABezShape bezRight = PACurveUtility.calculateCurve(pointsRight);
        if (isDrawWeighted) {
            bezLeft = PACurveUtility.calculateWeightedCurve(bezLeft, bias);
            bezRight = PACurveUtility.calculateWeightedCurve(bezRight, bias);
        }
        ListIterator<PAVertex2DINF> it = bezLeft.curveIterator();
        while (it.hasNext()) {
            bezRight.append(it.next());
        }
        bezRight.setIsClosed(true);
        return bezRight;
    }

    public static PABezShape quickBrushShape(ArrayList<PVector> points, float brushWidth) {
        return PACurveUtility.quickBrushShape(points, brushWidth, false, 0.0f);
    }

    public static PABezShape quickBrushShape(ArrayList<PVector> points, float brushWidth, float bias) {
        return PACurveUtility.quickBrushShape(points, brushWidth, true, bias);
    }

    public static PVector normalAtPoint(PVector a1, PVector a2, float u, float d) {
        float ax1 = a1.x;
        float ay1 = a1.y;
        float ax2 = a2.x;
        float ay2 = a2.y;
        float f = ax2 - ax1;
        float g = ay2 - ay1;
        float pux = ax1 + f * u;
        float puy = ay1 + g * u;
        float root = PApplet.sqrt((float)(f * f + g * g));
        float inv = 1.0f / root;
        float x = pux - g * inv * d;
        float y = puy + f * inv * d;
        return new PVector(x, y);
    }

    public static PVector scaledNormalAtPoint(PVector anchor, PVector normal, float d) {
        return new PVector(anchor.x + normal.x * d, anchor.y + normal.y * d);
    }

    public static void reverseArray(ArrayList<PVector> arr, int l, int r) {
        while (l < r) {
            PVector temp = arr.get(l);
            arr.set(l, arr.get(r));
            arr.set(r, temp);
            ++l;
            --r;
        }
    }

    public static void lineDraw(PApplet parent, ArrayList<PVector> points, int lineColor, float lineWeight) {
        if (points.size() > 1) {
            parent.stroke(lineColor);
            parent.strokeWeight(lineWeight);
            parent.noFill();
            parent.beginShape();
            for (PVector vec : points) {
                parent.vertex(vec.x, vec.y);
            }
            parent.endShape();
        }
    }

    public static void lineDraw(PGraphics pg, ArrayList<PVector> points, int lineColor, float lineWeight) {
        if (points.size() > 1) {
            pg.stroke(lineColor);
            pg.strokeWeight(lineWeight);
            pg.noFill();
            pg.beginShape();
            for (PVector vec : points) {
                pg.vertex(vec.x, vec.y);
            }
            pg.endShape();
        }
    }

    public static void curveDraw(PApplet parent, PABezShape curve, int curveColor, float curveWeight) {
        if (curve != null && curve.size() > 0) {
            parent.pushStyle();
            parent.stroke(curveColor);
            parent.strokeWeight(curveWeight);
            parent.noFill();
            curve.drawQuick(parent);
            parent.popStyle();
        }
    }

    public static void curveDraw(PApplet parent, PABezShape curve) {
        if (curve != null && curve.size() > 0) {
            curve.draw(parent);
        }
    }

    public static void curveDraw(PGraphics pg, PABezShape curve, int curveColor, float curveWeight) {
        if (curve != null && curve.size() > 0) {
            pg.pushStyle();
            pg.stroke(curveColor);
            pg.strokeWeight(curveWeight);
            pg.noFill();
            curve.drawQuick(pg);
            pg.popStyle();
        }
    }

    public static void curveDraw(PGraphics pg, PABezShape curve) {
        if (curve != null && curve.size() > 0) {
            curve.draw(pg);
        }
    }

    public static void shapeDraw(PApplet parent, PABezShape shape, int shapeFill, int shapeStroke, float shapeWeight) {
        if (shape != null && shape.size() > 0) {
            parent.pushStyle();
            parent.stroke(shapeStroke);
            parent.strokeWeight(shapeWeight);
            if (shapeWeight == 0.0f) {
                parent.noStroke();
            } else {
                parent.fill(shapeStroke);
            }
            shape.drawQuick(parent);
            parent.popStyle();
        }
    }

    public static void shapeDraw(PApplet parent, PABezShape shape) {
        if (shape != null && shape.size() > 0) {
            shape.draw(parent);
        }
    }

    public static void shapeDraw(PGraphics pg, PABezShape shape, int shapeFill, int shapeStroke, float shapeWeight) {
        if (shape != null && shape.size() > 0) {
            pg.pushStyle();
            pg.stroke(shapeStroke);
            pg.strokeWeight(shapeWeight);
            if (shapeWeight == 0.0f) {
                pg.noFill();
            } else {
                pg.fill(shapeStroke);
            }
            shape.drawQuick(pg);
            pg.popStyle();
        }
    }

    public static void shapeDraw(PGraphics pg, PABezShape shape) {
        if (shape != null && shape.size() > 0) {
            shape.draw(pg);
        }
    }
}

