/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.curves;

import net.paulhertz.pixelaudio.curves.PAVertex2DINF;
import processing.core.PApplet;
import processing.core.PGraphics;

public class PALineVertex
implements PAVertex2DINF {
    protected float x;
    protected float y;
    public static final int segmentType = 1;

    public PALineVertex(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public PALineVertex() {
        this(0.0f, 0.0f);
    }

    @Override
    public float x() {
        return this.x;
    }

    public void setX(float newX) {
        this.x = newX;
    }

    @Override
    public float y() {
        return this.y;
    }

    public void setY(float newY) {
        this.y = newY;
    }

    @Override
    public int segmentType() {
        return 1;
    }

    @Override
    public float[] coords() {
        float[] knots = new float[]{this.x, this.y};
        return knots;
    }

    @Override
    public PALineVertex clone() {
        return new PALineVertex(this.x, this.y);
    }

    @Override
    public void draw(PApplet parent) {
        parent.vertex(this.x, this.y);
    }

    @Override
    public void draw(PGraphics pg) {
        pg.vertex(this.x, this.y);
    }

    @Override
    public void mark(PApplet parent) {
        int w = 6;
        parent.pushStyle();
        parent.noStroke();
        parent.fill(160);
        parent.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
        parent.popStyle();
    }

    @Override
    public void mark(PGraphics pg) {
        int w = 6;
        pg.pushStyle();
        pg.noStroke();
        pg.fill(160);
        pg.square(this.x - (float)(w / 2), this.y - (float)(w / 2), (float)w);
        pg.popStyle();
    }
}

