/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import net.paulhertz.pixelaudio.voices.ADSRParams;

public final class ADSRUtils {
    private ADSRUtils() {
    }

    public static ADSRParams fitEnvelopeToDuration(ADSRParams adsr, int duration) {
        if (adsr == null) {
            throw new IllegalArgumentException("ADSRParams must not be null");
        }
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        float totalSeconds = (float)duration / 1000.0f;
        float totalEnv = adsr.getAttack() + adsr.getDecay() + adsr.getRelease();
        if (totalEnv <= 0.0f) {
            return new ADSRParams(adsr.getMaxAmp(), 0.0f, 0.0f, adsr.getSustain(), 0.0f);
        }
        float scale = totalSeconds / totalEnv;
        return new ADSRParams(adsr.getMaxAmp(), adsr.getAttack() * scale, adsr.getDecay() * scale, adsr.getSustain(), adsr.getRelease() * scale);
    }
}

