/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import ddf.minim.AudioOutput;
import ddf.minim.MultiChannelBuffer;
import java.util.Arrays;
import net.paulhertz.pixelaudio.voices.ADSRParams;
import net.paulhertz.pixelaudio.voices.PASampler;
import net.paulhertz.pixelaudio.voices.PASamplerPlayable;
import net.paulhertz.pixelaudio.voices.PASamplerVoice;
import net.paulhertz.pixelaudio.voices.PASharedBufferSampler;

public class PASamplerInstrument
implements PASamplerPlayable {
    private final PASampler sampler;
    private MultiChannelBuffer buffer;
    private final AudioOutput out;
    private int bufferSize;
    private int maxVoices;
    private float bufferSampleRate;
    private float outputSampleRate;
    private float sampleRateRatio;
    private ADSRParams defaultEnv;
    private volatile float globalPitch = 1.0f;
    private float globalPan = 0.0f;
    private boolean isClosed = false;

    public PASamplerInstrument(MultiChannelBuffer buffer, float sampleRate, int maxVoices, AudioOutput audioOut, ADSRParams env) {
        this.out = audioOut;
        this.buffer = buffer;
        this.bufferSize = buffer.getBufferSize();
        this.bufferSampleRate = sampleRate;
        this.outputSampleRate = audioOut != null ? audioOut.sampleRate() : sampleRate;
        this.sampleRateRatio = this.outputSampleRate > 0.0f ? this.bufferSampleRate / this.outputSampleRate : 1.0f;
        this.defaultEnv = env != null ? env : new ADSRParams(1.0f, 0.01f, 0.2f, 0.8f, 0.3f);
        this.globalPitch = 1.0f;
        this.globalPan = 0.0f;
        this.isClosed = false;
        this.maxVoices = Math.max(1, maxVoices);
        this.sampler = new PASharedBufferSampler(buffer, sampleRate, audioOut, this.maxVoices);
    }

    public PASamplerInstrument(MultiChannelBuffer buffer, AudioOutput out, PASampler sampler, ADSRParams defaultEnv, float bufferSampleRate) {
        this.out = out;
        this.buffer = buffer;
        this.sampler = sampler;
        this.defaultEnv = defaultEnv;
        this.bufferSize = buffer != null ? buffer.getBufferSize() : 0;
        this.outputSampleRate = out != null ? out.sampleRate() : bufferSampleRate;
        this.bufferSampleRate = bufferSampleRate;
        this.sampleRateRatio = this.outputSampleRate > 0.0f ? bufferSampleRate / this.outputSampleRate : 1.0f;
    }

    public PASamplerInstrument(MultiChannelBuffer buffer, AudioOutput out) {
        this(buffer, out, new PASharedBufferSampler(buffer, out.sampleRate(), out), new ADSRParams(1.0f, 0.01f, 0.2f, 0.8f, 0.3f), out.sampleRate());
    }

    @Override
    public int play(float amplitude, float pitch, float pan) {
        if (this.sampler == null || this.bufferSize <= 0) {
            return 0;
        }
        float scaledPitch = pitch * this.globalPitch * this.sampleRateRatio;
        float finalPan = PASamplerInstrument.clampPan(this.globalPan + pan);
        return this.sampler.play(0, this.bufferSize, amplitude, this.defaultEnv, scaledPitch, finalPan);
    }

    @Override
    public int play(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        if (this.sampler == null || this.bufferSize <= 0) {
            return 0;
        }
        float scaledPitch = pitch * this.globalPitch * this.sampleRateRatio;
        float finalPan = PASamplerInstrument.clampPan(this.globalPan + pan);
        ADSRParams useEnv = env != null ? env : this.defaultEnv;
        return this.sampler.play(samplePos, sampleLen, amplitude, useEnv, scaledPitch, finalPan);
    }

    @Override
    public void stop() {
        if (this.sampler != null) {
            this.sampler.stopAll();
        }
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        return this.play(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, float pitch, float pan) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, pitch, pan);
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, this.globalPitch, this.globalPan);
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, float pitch) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, pitch, this.globalPan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env) {
        return this.play(samplePos, sampleLen, amplitude, env, this.globalPitch, this.globalPan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        return this.play(samplePos, sampleLen, amplitude, env, pitch, this.globalPan);
    }

    public synchronized int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        if (buffer != null) {
            this.setBuffer(buffer);
        }
        return this.play(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        if (buffer != null) {
            this.setBuffer(buffer);
        }
        return this.play(samplePos, sampleLen, amplitude, env, pitch, this.globalPan);
    }

    public boolean hasAvailableVoice() {
        if (this.sampler == null) {
            return false;
        }
        for (PASamplerVoice v : ((PASharedBufferSampler)this.sampler).getVoices()) {
            if (!v.isFinished() && (v.isActive() || v.isReleasing())) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveOrReleasingVoices() {
        PASharedBufferSampler s = (PASharedBufferSampler)this.getSampler();
        for (PASamplerVoice v : s.getVoices()) {
            if (!v.isActive() && !v.isReleasing()) continue;
            return true;
        }
        return false;
    }

    public int activeOrReleasingVoiceCount() {
        PASharedBufferSampler s = (PASharedBufferSampler)this.getSampler();
        int c = 0;
        for (PASamplerVoice v : s.getVoices()) {
            if (!v.isActive() && !v.isReleasing()) continue;
            ++c;
        }
        return c;
    }

    public void releaseAllVoices() {
        PASharedBufferSampler s = (PASharedBufferSampler)this.getSampler();
        for (PASamplerVoice v : s.getVoices()) {
            if (!v.isActive() && !v.isReleasing()) continue;
            v.release();
        }
    }

    public PASampler getSampler() {
        return this.sampler;
    }

    public MultiChannelBuffer getBuffer() {
        return this.buffer;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer) {
        if (newBuffer != null) {
            this.buffer.set(newBuffer);
            this.bufferSize = newBuffer.getBufferSize();
            float[] sharedBuffer = Arrays.copyOf(newBuffer.getChannel(0), newBuffer.getBufferSize());
            this.sampler.setBuffer(sharedBuffer);
        }
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer, float newSampleRate) {
        if (newBuffer != null) {
            this.buffer.set(newBuffer);
            this.bufferSize = newBuffer.getBufferSize();
            this.setBufferSampleRate(newSampleRate);
            float[] sharedBuffer = Arrays.copyOf(newBuffer.getChannel(0), newBuffer.getBufferSize());
            this.sampler.setBuffer(sharedBuffer);
        }
    }

    public synchronized void setBuffer(float[] newBuffer, float newSampleRate) {
        if (newBuffer == null || newBuffer.length == 0) {
            return;
        }
        if (this.buffer == null || this.buffer.getBufferSize() != newBuffer.length) {
            this.buffer.setBufferSize(newBuffer.length);
        }
        this.buffer.setChannel(0, newBuffer);
        this.bufferSize = newBuffer.length;
        this.setBufferSampleRate(newSampleRate);
        this.sampler.setBuffer(Arrays.copyOf(newBuffer, newBuffer.length), newSampleRate);
    }

    public AudioOutput getAudioOutput() {
        return this.out;
    }

    public float getBufferSampleRate() {
        return this.bufferSampleRate;
    }

    public float getOutputSampleRate() {
        return this.outputSampleRate;
    }

    public float getSampleRateRatio() {
        return this.sampleRateRatio;
    }

    public synchronized void setBufferSampleRate(float newRate) {
        if (newRate > 0.0f) {
            this.bufferSampleRate = newRate;
            float f = this.sampleRateRatio = this.outputSampleRate > 0.0f ? this.bufferSampleRate / this.outputSampleRate : 1.0f;
            if (this.sampler != null) {
                this.sampler.setSampleRate(newRate);
            }
        }
    }

    public synchronized void setOutputSampleRate(float newRate) {
        if (newRate > 0.0f) {
            this.outputSampleRate = newRate;
            this.sampleRateRatio = this.bufferSampleRate / this.outputSampleRate;
        }
    }

    public synchronized void updateRateFromOutput() {
        if (this.out != null) {
            this.setOutputSampleRate(this.out.sampleRate());
        }
    }

    public ADSRParams getDefaultEnv() {
        return this.defaultEnv;
    }

    public void setDefaultEnv(ADSRParams env) {
        this.defaultEnv = env;
    }

    public void setPitchScale(float scale) {
        this.globalPitch = scale;
    }

    public float getPitchScale() {
        return this.globalPitch;
    }

    public void setGlobalPan(float pan) {
        this.globalPan = PASamplerInstrument.clampPan(pan);
    }

    public float getGlobalPan() {
        return this.globalPan;
    }

    private static float clampPan(float pan) {
        if (pan < -1.0f) {
            return -1.0f;
        }
        if (pan > 1.0f) {
            return 1.0f;
        }
        return pan;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.stop();
        if (this.sampler != null) {
            // empty if block
        }
        this.buffer = null;
        this.isClosed = true;
    }
}

