/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import ddf.minim.AudioOutput;
import ddf.minim.MultiChannelBuffer;
import java.util.ArrayList;
import java.util.List;
import net.paulhertz.pixelaudio.voices.ADSRParams;
import net.paulhertz.pixelaudio.voices.PAPlayable;
import net.paulhertz.pixelaudio.voices.PASamplerInstrument;
import net.paulhertz.pixelaudio.voices.PASamplerPlayable;

public class PASamplerInstrumentPool
implements PASamplerPlayable,
PAPlayable {
    private final AudioOutput out;
    private MultiChannelBuffer buffer;
    private final List<PASamplerInstrument> pool = new ArrayList<PASamplerInstrument>();
    private int poolSize;
    private int maxVoices = 8;
    private ADSRParams defaultEnv;
    private float globalPitch = 1.0f;
    private float globalPan = 0.0f;
    private int outputBufferSize;
    private float bufferSampleRate;
    private float outputSampleRate;
    private boolean isClosed = false;

    public PASamplerInstrumentPool(MultiChannelBuffer buffer, float sampleRate, int poolSize, int perInstrumentVoices, AudioOutput out, ADSRParams defaultEnv) {
        this.out = out;
        this.buffer = buffer;
        this.poolSize = Math.max(1, poolSize);
        this.maxVoices = perInstrumentVoices;
        this.bufferSampleRate = sampleRate;
        this.outputSampleRate = out != null ? out.sampleRate() : sampleRate;
        this.outputBufferSize = out != null ? out.bufferSize() : 1024;
        this.defaultEnv = defaultEnv != null ? defaultEnv : new ADSRParams(0.8f, 0.01f, 0.2f, 0.8f, 0.3f);
        this.globalPitch = 1.0f;
        this.globalPan = 0.0f;
        this.initPool();
    }

    public PASamplerInstrumentPool(MultiChannelBuffer buffer, AudioOutput out, int poolSize, float bufferSampleRate, ADSRParams env) {
        this.out = out;
        this.buffer = buffer;
        this.poolSize = Math.max(1, poolSize);
        this.bufferSampleRate = bufferSampleRate;
        this.defaultEnv = env != null ? env : new ADSRParams(1.0f, 0.01f, 0.2f, 0.8f, 0.3f);
        this.outputSampleRate = out != null ? out.sampleRate() : bufferSampleRate;
        this.outputBufferSize = out != null ? out.bufferSize() : 1024;
        this.initPool();
    }

    public PASamplerInstrumentPool(MultiChannelBuffer buffer, AudioOutput out, int poolSize) {
        this(buffer, out, poolSize, out.sampleRate(), new ADSRParams(0.8f, 0.01f, 0.2f, 0.8f, 0.3f));
    }

    private synchronized void initPool() {
        this.pool.clear();
        int i = 0;
        while (i < this.poolSize) {
            PASamplerInstrument inst = new PASamplerInstrument(this.buffer, this.bufferSampleRate, this.maxVoices, this.out, this.defaultEnv);
            inst.setPitchScale(this.globalPitch);
            inst.setGlobalPan(this.globalPan);
            this.pool.add(inst);
            ++i;
        }
    }

    private synchronized PASamplerInstrument getAvailableInstrument() {
        PASamplerInstrument free = null;
        PASamplerInstrument leastBusy = null;
        int leastCount = Integer.MAX_VALUE;
        for (PASamplerInstrument inst : this.pool) {
            if (!inst.hasActiveOrReleasingVoices()) {
                free = inst;
                break;
            }
            int c = inst.activeOrReleasingVoiceCount();
            if (c >= leastCount) continue;
            leastCount = c;
            leastBusy = inst;
        }
        if (free != null) {
            return free;
        }
        if (leastBusy != null) {
            return leastBusy;
        }
        PASamplerInstrument victim = this.pool.get(0);
        victim.releaseAllVoices();
        return victim;
    }

    @Override
    public synchronized int play(float amplitude, float pitch, float pan) {
        PASamplerInstrument inst = this.getAvailableInstrument();
        if (inst == null) {
            return 0;
        }
        return inst.play(amplitude, pitch, pan);
    }

    @Override
    public synchronized void stop() {
        for (PASamplerInstrument inst : this.pool) {
            inst.stop();
        }
    }

    @Override
    public synchronized int play(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrument inst = this.getAvailableInstrument();
        if (inst == null) {
            return 0;
        }
        return inst.play(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized boolean isLooping() {
        for (PASamplerInstrument inst : this.pool) {
            if (!inst.getSampler().isLooping()) continue;
            return true;
        }
        return false;
    }

    public synchronized void stopAll() {
        this.stop();
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        return this.play(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, float pitch, float pan) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, pitch, pan);
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, this.globalPitch, this.globalPan);
    }

    @Override
    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, float pitch) {
        return this.play(samplePos, sampleLen, amplitude, this.defaultEnv, pitch, this.globalPan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env) {
        return this.play(samplePos, sampleLen, amplitude, env, this.globalPitch, this.globalPan);
    }

    public synchronized int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        return this.play(samplePos, sampleLen, amplitude, env, pitch, this.globalPan);
    }

    public synchronized int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrument inst = this.getAvailableInstrument();
        if (inst == null) {
            return 0;
        }
        inst.setBuffer(buffer, this.bufferSampleRate);
        return inst.play(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        return this.playSample(buffer, samplePos, sampleLen, amplitude, env, pitch, this.globalPan);
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer) {
        if (newBuffer == null) {
            return;
        }
        if (this.buffer.getChannelCount() != newBuffer.getChannelCount() || this.buffer.getBufferSize() != newBuffer.getBufferSize()) {
            this.buffer = new MultiChannelBuffer(newBuffer.getBufferSize(), newBuffer.getChannelCount());
            this.buffer.set(newBuffer);
        } else {
            this.buffer.set(newBuffer);
        }
        for (PASamplerInstrument inst : this.pool) {
            inst.setBuffer(newBuffer);
        }
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer, float newBufferSampleRate) {
        if (newBuffer == null) {
            return;
        }
        if (this.buffer.getChannelCount() != newBuffer.getChannelCount() || this.buffer.getBufferSize() != newBuffer.getBufferSize()) {
            this.buffer = new MultiChannelBuffer(newBuffer.getBufferSize(), newBuffer.getChannelCount());
            this.buffer.set(newBuffer);
        } else {
            this.buffer.set(newBuffer);
        }
        this.bufferSampleRate = newBufferSampleRate;
        for (PASamplerInstrument inst : this.pool) {
            inst.setBuffer(newBuffer, newBufferSampleRate);
        }
    }

    public synchronized void setBuffer(float[] newBuffer, float newBufferSampleRate) {
        if (newBuffer == null || newBuffer.length == 0) {
            return;
        }
        if (newBuffer.length != this.buffer.getBufferSize()) {
            this.buffer = new MultiChannelBuffer(newBuffer.length, 1);
        } else {
            this.buffer.setChannel(0, newBuffer);
        }
        this.bufferSampleRate = newBufferSampleRate;
        for (PASamplerInstrument inst : this.pool) {
            inst.setBuffer(newBuffer, newBufferSampleRate);
        }
    }

    public synchronized void updateRateFromOutput() {
        if (this.out == null) {
            return;
        }
        this.outputSampleRate = this.out.sampleRate();
        this.outputBufferSize = this.out.bufferSize();
        for (PASamplerInstrument inst : this.pool) {
            inst.setOutputSampleRate(this.outputSampleRate);
        }
    }

    public synchronized void setGlobalPitch(float pitch) {
        this.globalPitch = pitch;
    }

    public synchronized float getGlobalPitch() {
        return this.globalPitch;
    }

    public synchronized void setGlobalPan(float pan) {
        this.globalPan = PASamplerInstrumentPool.clampPan(pan);
    }

    public synchronized float getGlobalPan() {
        return this.globalPan;
    }

    public synchronized void setDefaultEnv(ADSRParams env) {
        this.defaultEnv = env != null ? env : this.defaultEnv;
        for (PASamplerInstrument inst : this.pool) {
            inst.setDefaultEnv(this.defaultEnv);
        }
    }

    public synchronized ADSRParams getDefaultEnv() {
        return this.defaultEnv;
    }

    public int getMaxVoices() {
        return this.maxVoices;
    }

    public synchronized void setMaxVoices(int maxVoices) {
        this.maxVoices = Math.max(1, maxVoices);
        this.reinitInstruments();
    }

    public synchronized int getPoolSize() {
        return this.pool.size();
    }

    public synchronized void setPoolSize(int newSize) {
        if (newSize != this.poolSize) {
            this.poolSize = Math.max(1, newSize);
            this.reinitInstruments();
        }
    }

    public synchronized float getOutputSampleRate() {
        return this.outputSampleRate;
    }

    public synchronized int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public synchronized float getBufferSampleRate() {
        return this.bufferSampleRate;
    }

    private synchronized void reinitInstruments() {
        int currentSize = this.pool.size();
        if (this.poolSize > currentSize) {
            i = currentSize;
            while (i < this.poolSize) {
                inst = new PASamplerInstrument(this.buffer, this.bufferSampleRate, this.maxVoices, this.out, this.defaultEnv);
                inst.setPitchScale(this.globalPitch);
                inst.setGlobalPan(this.globalPan);
                this.pool.add(inst);
                ++i;
            }
        } else if (this.poolSize < currentSize) {
            i = this.poolSize;
            while (i < currentSize) {
                inst = this.pool.get(i);
                inst.stop();
                inst.close();
                ++i;
            }
            while (this.pool.size() > this.poolSize) {
                this.pool.remove(this.pool.size() - 1);
            }
        }
        for (PASamplerInstrument inst : this.pool) {
            inst.setDefaultEnv(this.defaultEnv);
            inst.setPitchScale(this.globalPitch);
            inst.setGlobalPan(this.globalPan);
        }
    }

    public List<PASamplerInstrument> getInstruments() {
        return this.pool;
    }

    public synchronized void schedulePlayAtMillis(long triggerTimeMillis, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        this.playSample(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized void schedulePlayAtFrame(long frameIndex, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        this.playSample(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    private static float clampPan(float pan) {
        return pan < -1.0f ? -1.0f : (pan > 1.0f ? 1.0f : pan);
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.stopAll();
        for (PASamplerInstrument inst : this.pool) {
            inst.close();
        }
        this.pool.clear();
        this.buffer = null;
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }
}

