/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import ddf.minim.AudioOutput;
import ddf.minim.MultiChannelBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.paulhertz.pixelaudio.voices.ADSRParams;
import net.paulhertz.pixelaudio.voices.PAPlayable;
import net.paulhertz.pixelaudio.voices.PASamplerInstrumentPool;
import net.paulhertz.pixelaudio.voices.PASamplerPlayable;

public class PASamplerInstrumentPoolMulti
implements PASamplerPlayable,
PAPlayable {
    private final AudioOutput out;
    private final Map<String, PASamplerInstrumentPool> pools = new LinkedHashMap<String, PASamplerInstrumentPool>();
    private String activeKey = null;
    private boolean isClosed = false;

    public PASamplerInstrumentPoolMulti(AudioOutput out) {
        this.out = out;
    }

    public PASamplerInstrumentPoolMulti(String key, MultiChannelBuffer buffer, float sampleRate, int poolSize, int perInstrumentVoices, AudioOutput out, ADSRParams adsr) {
        this(out);
        this.addPool(key, buffer, sampleRate, poolSize, perInstrumentVoices, out, adsr);
    }

    public void addPool(String key, MultiChannelBuffer buffer, float bufferSampleRate, int poolSize, int perInstrumentVoices, AudioOutput out, ADSRParams env) {
        if (key == null || buffer == null) {
            return;
        }
        if (this.isClosed) {
            return;
        }
        PASamplerInstrumentPool p = new PASamplerInstrumentPool(buffer, bufferSampleRate, poolSize, perInstrumentVoices, out, env);
        this.pools.put(key, p);
        if (this.activeKey == null) {
            this.activeKey = key;
        }
    }

    public synchronized void removePool(String key) {
        PASamplerInstrumentPool p = this.pools.remove(key);
        if (p != null) {
            p.stopAll();
            p.close();
        }
        if (key.equals(this.activeKey)) {
            this.activeKey = this.pools.isEmpty() ? null : this.pools.keySet().iterator().next();
        }
    }

    private synchronized PASamplerInstrumentPool current() {
        return this.activeKey != null ? this.pools.get(this.activeKey) : null;
    }

    public synchronized void setActive(String key) {
        if (this.pools.containsKey(key)) {
            this.activeKey = key;
        }
    }

    public synchronized String getActiveKey() {
        return this.activeKey;
    }

    @Override
    public int play(float amplitude, float pitch, float pan) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.play(amplitude, pitch, pan) : 0;
    }

    @Override
    public void stop() {
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.stop();
        }
    }

    @Override
    public int play(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.play(samplePos, sampleLen, amplitude, env, pitch, pan) : 0;
    }

    public boolean isLooping() {
        for (PASamplerInstrumentPool p : this.pools.values()) {
            if (!p.isLooping()) continue;
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.stopAll();
        }
    }

    @Override
    public int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude, env, pitch, pan) : 0;
    }

    public int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude, env, pitch) : 0;
    }

    public int playSample(int samplePos, int sampleLen, float amplitude, float pitch, float pan) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude, pitch, pan) : 0;
    }

    @Override
    public int playSample(int samplePos, int sampleLen, float amplitude) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude) : 0;
    }

    @Override
    public int playSample(int samplePos, int sampleLen, float amplitude, float pitch) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude, pitch) : 0;
    }

    public int playSample(int samplePos, int sampleLen, float amplitude, ADSRParams env) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(samplePos, sampleLen, amplitude, env) : 0;
    }

    public int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(buffer, samplePos, sampleLen, amplitude, env, pitch, pan) : 0;
    }

    public int playSample(MultiChannelBuffer buffer, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch) {
        PASamplerInstrumentPool p = this.current();
        return p != null ? p.playSample(buffer, samplePos, sampleLen, amplitude, env, pitch) : 0;
    }

    public synchronized int playSample(String tag, int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerInstrumentPool pool = this.getPoolByTag(tag);
        if (pool == null) {
            throw new IllegalArgumentException("No buffer found for tag: " + tag);
        }
        return pool.playSample(samplePos, sampleLen, amplitude, env, pitch, pan);
    }

    public synchronized boolean hasPool(String tag) {
        return tag != null && this.pools.containsKey(tag);
    }

    public synchronized PASamplerInstrumentPool getPoolByTag(String tag) {
        if (tag == null) {
            return null;
        }
        return this.pools.get(tag);
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer) {
        if (newBuffer == null) {
            return;
        }
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.setBuffer(newBuffer);
        }
    }

    public synchronized void setBuffer(MultiChannelBuffer newBuffer, float newSampleRate) {
        if (newBuffer == null) {
            return;
        }
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.setBuffer(newBuffer, newSampleRate);
        }
    }

    public synchronized void setBuffer(float[] newBuffer, float newSampleRate) {
        if (newBuffer == null || newBuffer.length == 0) {
            return;
        }
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.setBuffer(newBuffer, newSampleRate);
        }
    }

    public synchronized void updateRateFromOutput() {
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.updateRateFromOutput();
        }
    }

    public synchronized void resizeAllPools(int newPoolSize, int newVoicesPerInstrument) {
        for (PASamplerInstrumentPool p : this.pools.values()) {
            p.setPoolSize(newPoolSize);
            p.setMaxVoices(newVoicesPerInstrument);
        }
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        for (PASamplerInstrumentPool pool : this.pools.values()) {
            pool.close();
        }
        this.pools.clear();
        this.activeKey = null;
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized int getPoolCount() {
        return this.pools.size();
    }

    public synchronized Map<String, PASamplerInstrumentPool> getPools() {
        return this.pools;
    }

    public synchronized void debugPrintState() {
        System.out.printf("PASamplerInstrumentPoolMulti: %d pools active%n", this.pools.size());
        for (Map.Entry<String, PASamplerInstrumentPool> e : this.pools.entrySet()) {
            System.out.printf("  \u2022 %s : %d instruments, %.1f Hz buffer rate%n", e.getKey(), e.getValue().getPoolSize(), Float.valueOf(e.getValue().getBufferSampleRate()));
        }
    }
}

