/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import net.paulhertz.pixelaudio.voices.ADSRParams;
import net.paulhertz.pixelaudio.voices.SimpleADSR;

public class PASamplerVoice {
    private static long NEXT_VOICE_ID = 0L;
    private float[] buffer;
    private float playbackSampleRate;
    private long voiceId;
    private boolean active;
    private boolean released;
    private boolean finished;
    private boolean looping;
    private int start;
    private int end;
    private float position;
    private float rate;
    private float gain;
    private float pan;
    private SimpleADSR envelope;
    private boolean isFindZeroCrossing = false;
    private boolean isMicroFadeIn = false;
    private static final boolean DEBUG = false;
    private int frameCounter = 0;

    public PASamplerVoice(float[] buffer, float sampleRate) {
        this.buffer = buffer;
        this.playbackSampleRate = sampleRate;
        this.active = false;
        this.released = false;
        this.finished = false;
    }

    public void activate(int start, int length, float gain, ADSRParams envParams, float pitch, float pan, boolean looping) {
        this.active = false;
        this.released = false;
        this.finished = false;
        this.looping = looping;
        this.voiceId = NEXT_VOICE_ID++;
        this.start = Math.max(0, start);
        this.end = Math.min(this.buffer.length, start + Math.max(0, length));
        this.position = this.start;
        this.rate = pitch;
        this.gain = gain;
        this.pan = Math.max(-1.0f, Math.min(1.0f, pan));
        if (this.isFindZeroCrossing) {
            this.start = this.findZeroCrossing(this.start, 1);
            this.position = this.start;
        }
        if (envParams != null) {
            this.envelope = new SimpleADSR(envParams.getAttack(), envParams.getDecay(), envParams.getSustain(), envParams.getRelease());
            this.envelope.setSampleRate(this.playbackSampleRate);
            this.envelope.noteOn();
        } else {
            this.envelope = null;
        }
        if (this.isMicroFadeIn) {
            this.applyMicroFadeIn();
        }
        this.active = this.start < this.end;
    }

    public float nextSample() {
        if (this.finished || this.buffer == null) {
            return 0.0f;
        }
        int idx = (int)this.position;
        if (idx >= this.end && !this.released) {
            this.released = true;
            if (this.envelope != null) {
                this.envelope.noteOff();
            }
        }
        if (idx >= this.buffer.length) {
            idx = this.buffer.length - 1;
        }
        float base = idx >= 0 && idx < this.buffer.length ? this.buffer[idx] : 0.0f;
        this.position += this.rate;
        float envValue = this.envelope != null ? this.envelope.tick() : 1.0f;
        float sample = base * this.gain * envValue;
        if (this.released && (this.envelope == null || this.envelope.isFinished())) {
            this.active = false;
            this.finished = true;
        }
        return sample;
    }

    public void release() {
        if (!this.released) {
            this.released = true;
            if (this.envelope != null) {
                this.envelope.noteOff();
            }
        }
        this.looping = false;
    }

    public void stop() {
        this.active = false;
        this.released = false;
        this.finished = true;
    }

    public void resetPosition() {
        this.start = 0;
        this.end = this.buffer != null ? this.buffer.length : 0;
        this.position = 0.0f;
        this.released = false;
        this.active = false;
        this.finished = false;
    }

    public synchronized void setBuffer(float[] buffer) {
        this.buffer = buffer;
        this.resetPosition();
    }

    public synchronized void setBuffer(float[] buffer, float playbackSampleRate) {
        this.buffer = buffer;
        this.playbackSampleRate = playbackSampleRate;
        this.resetPosition();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isReleasing() {
        return this.released && !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public float getPan() {
        return this.pan;
    }

    public long getVoiceId() {
        return this.voiceId;
    }

    private void applyMicroFadeIn() {
        int fadeSamples = Math.min(64, this.end - this.start);
        float fadeAmp = 0.0f;
        float fadeStep = 1.0f / (float)fadeSamples;
        int i = 0;
        while (i < fadeSamples) {
            int n = this.start + i;
            this.buffer[n] = this.buffer[n] * fadeAmp;
            fadeAmp += fadeStep;
            ++i;
        }
    }

    private int findZeroCrossing(int index, int direction) {
        int limit = Math.min(this.buffer.length - 2, Math.max(1, index));
        int step = direction >= 0 ? 1 : -1;
        float prev = this.buffer[limit];
        int i = 0;
        while (i < 256 && limit + i * step > 1 && limit + i * step < this.buffer.length - 1) {
            int pos = limit + i * step;
            float next = this.buffer[pos];
            if (prev <= 0.0f && next > 0.0f || prev >= 0.0f && next < 0.0f) {
                return pos;
            }
            prev = next;
            ++i;
        }
        return index;
    }

    public boolean isFindZeroCrossing() {
        return this.isFindZeroCrossing;
    }

    public void setFindZeroCrossing(boolean val) {
        this.isFindZeroCrossing = val;
    }

    public boolean isMicroFadeIn() {
        return this.isMicroFadeIn;
    }

    public void setMicroFadeIn(boolean val) {
        this.isMicroFadeIn = val;
    }

    public void setPlaybackSampleRate(float newRate) {
        this.playbackSampleRate = newRate;
    }
}

