/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import ddf.minim.AudioOutput;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.UGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.paulhertz.pixelaudio.voices.ADSRParams;
import net.paulhertz.pixelaudio.voices.PASampler;
import net.paulhertz.pixelaudio.voices.PASamplerVoice;
import net.paulhertz.pixelaudio.voices.PlaybackInfo;

public class PASharedBufferSampler
extends UGen
implements PASampler {
    private float[] buffer;
    private int bufferLen;
    private float playbackSampleRate;
    private final AudioOutput out;
    private final List<PASamplerVoice> voices = new ArrayList<PASamplerVoice>();
    private int maxVoices = 32;
    private boolean globalLooping = false;
    private boolean smoothSteal = true;
    protected boolean DEBUG = false;

    public PASharedBufferSampler(MultiChannelBuffer multiBuffer, float sampleRate, AudioOutput out) {
        this.buffer = Arrays.copyOf(multiBuffer.getChannel(0), multiBuffer.getBufferSize());
        this.bufferLen = this.buffer.length;
        this.playbackSampleRate = sampleRate;
        this.out = out;
        this.patch(out);
    }

    public PASharedBufferSampler(MultiChannelBuffer multiBuffer, float playbackSampleRate, AudioOutput out, int maxVoices) {
        this.buffer = Arrays.copyOf(multiBuffer.getChannel(0), multiBuffer.getBufferSize());
        this.bufferLen = this.buffer.length;
        this.playbackSampleRate = playbackSampleRate;
        this.out = out;
        this.maxVoices = Math.max(1, maxVoices);
        int i = 0;
        while (i < this.maxVoices) {
            this.voices.add(new PASamplerVoice(this.buffer, playbackSampleRate));
            ++i;
        }
        this.patch(out);
    }

    public PASharedBufferSampler(MultiChannelBuffer multiBuffer, AudioOutput out) {
        this(multiBuffer, out != null ? out.sampleRate() : 44100.0f, out);
    }

    @Override
    public synchronized int play(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan) {
        PASamplerVoice v;
        if (sampleLen <= 0 || samplePos >= this.bufferLen) {
            return 0;
        }
        if (samplePos < 0) {
            samplePos = 0;
        }
        if (samplePos + sampleLen > this.bufferLen) {
            sampleLen = this.bufferLen - samplePos;
        }
        if ((v = this.getAvailableVoice()) == null) {
            return 0;
        }
        v.activate(samplePos, sampleLen, amplitude, env, pitch, pan, this.globalLooping);
        int eventSamples = PlaybackInfo.computeVoiceDuration(samplePos, sampleLen, this.bufferLen, pitch, env, this.globalLooping, this.playbackSampleRate);
        float bufferReadSamples = (float)sampleLen * Math.abs(pitch);
        float durationMS = (float)eventSamples / this.playbackSampleRate * 1000.0f;
        long startSample = 0L;
        PlaybackInfo info = new PlaybackInfo(v.getVoiceId(), eventSamples, bufferReadSamples, durationMS, this.globalLooping, startSample, this.playbackSampleRate);
        if (this.DEBUG) {
            System.out.printf("[Voice %d] eventDuration=%d samples (%.2f ms)%n", v.getVoiceId(), eventSamples, Float.valueOf((float)eventSamples / this.playbackSampleRate * 1000.0f));
        }
        return eventSamples;
    }

    private PASamplerVoice getAvailableVoice() {
        for (PASamplerVoice v : this.voices) {
            if (v.isActive() || v.isReleasing()) continue;
            return v;
        }
        if (this.voices.size() < this.maxVoices) {
            PASamplerVoice v;
            v = new PASamplerVoice(this.buffer, this.playbackSampleRate);
            this.voices.add(v);
            return v;
        }
        PASamplerVoice oldest = null;
        for (PASamplerVoice v : this.voices) {
            if (!v.isActive() || oldest != null && v.getVoiceId() >= oldest.getVoiceId()) continue;
            oldest = v;
        }
        if (oldest != null) {
            if (this.smoothSteal) {
                oldest.release();
            } else {
                oldest.stop();
            }
            return oldest;
        }
        return null;
    }

    protected synchronized void uGenerate(float[] channels) {
        Arrays.fill(channels, 0.0f);
        for (PASamplerVoice v : this.voices) {
            float sample = 0.0f;
            try {
                sample = v.nextSample();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                v.stop();
                continue;
            }
            if (v.isActive() || v.isReleasing()) {
                float pan = v.getPan();
                float leftGain = pan <= 0.0f ? 1.0f : 1.0f - pan;
                float rightGain = pan >= 0.0f ? 1.0f : 1.0f + pan;
                channels[0] = channels[0] + sample * leftGain;
                if (channels.length > 1) {
                    channels[1] = channels[1] + sample * rightGain;
                }
            }
            if (!v.isFinished()) continue;
            v.resetPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAll() {
        PASharedBufferSampler pASharedBufferSampler = this;
        synchronized (pASharedBufferSampler) {
            for (PASamplerVoice v : this.voices) {
                v.stop();
            }
        }
    }

    @Override
    public boolean isLooping() {
        for (PASamplerVoice v : this.voices) {
            if (!v.isActive() || !v.isLooping()) continue;
            return true;
        }
        return false;
    }

    public void setGlobalLooping(boolean looping) {
        this.globalLooping = looping;
    }

    public boolean isGlobalLooping() {
        return this.globalLooping;
    }

    public void setSmoothSteal(boolean smoothSteal) {
        this.smoothSteal = smoothSteal;
    }

    public boolean isSmoothSteal() {
        return this.smoothSteal;
    }

    public synchronized void setMaxVoices(int maxVoices) {
        this.maxVoices = Math.max(1, maxVoices);
    }

    public int getMaxVoices() {
        return this.maxVoices;
    }

    public List<PASamplerVoice> getVoices() {
        return Collections.unmodifiableList(this.voices);
    }

    @Override
    public synchronized void setBuffer(float[] buffer) {
        this.buffer = buffer;
        for (PASamplerVoice v : this.voices) {
            v.stop();
            v.setBuffer(buffer);
            v.resetPosition();
        }
    }

    @Override
    public synchronized void setBuffer(float[] buffer, float playbackSampleRate) {
        this.buffer = buffer;
        this.playbackSampleRate = playbackSampleRate;
        for (PASamplerVoice v : this.voices) {
            v.stop();
            v.setBuffer(buffer);
            v.resetPosition();
        }
    }

    public int countAvailableVoices() {
        int n = 0;
        for (PASamplerVoice v : this.voices) {
            if (v.isActive() || v.isReleasing()) continue;
            ++n;
        }
        return n;
    }

    public synchronized float getPlaybackSampleRate() {
        return this.playbackSampleRate;
    }

    public synchronized void setPlaybackSampleRate(float newRate) {
        if (newRate > 0.0f && newRate != this.playbackSampleRate) {
            this.playbackSampleRate = newRate;
            for (PASamplerVoice v : this.voices) {
                v.setPlaybackSampleRate(newRate);
            }
        }
    }

    public synchronized void updatePlaybackRateFromOutput() {
        if (this.out != null) {
            this.setPlaybackSampleRate(this.out.sampleRate());
        }
    }

    public int getBufferLength() {
        return this.bufferLen;
    }

    public AudioOutput getAudioOutput() {
        return this.out;
    }
}

