/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

import net.paulhertz.pixelaudio.voices.ADSRParams;

public class PlaybackInfo {
    public final long voiceId;
    public final int eventSamples;
    public final float durationMS;
    public final float bufferReadSamples;
    public final boolean looping;
    public final long startSample;
    public final long stopSample;
    public final float startMS;
    public final float stopMS;

    public PlaybackInfo(long voiceId, int eventSamples, float bufferReadSamples, float durationMS, boolean looping, long startSample, float sampleRate) {
        this.voiceId = voiceId;
        this.eventSamples = eventSamples;
        this.durationMS = durationMS;
        this.bufferReadSamples = bufferReadSamples;
        this.looping = looping;
        this.startSample = startSample;
        this.stopSample = looping ? Long.MAX_VALUE : startSample + (long)eventSamples;
        this.startMS = (float)startSample / sampleRate * 1000.0f;
        this.stopMS = looping ? Float.POSITIVE_INFINITY : (float)this.stopSample / sampleRate * 1000.0f;
    }

    public static int computeVoiceDuration(int samplePos, int sampleLen, int bufferLen, float pitch, ADSRParams env, boolean looping, float sampleRate) {
        if (looping) {
            return Integer.MAX_VALUE;
        }
        samplePos = Math.max(0, samplePos);
        if (sampleLen < 0) {
            sampleLen = 0;
        }
        if (samplePos + sampleLen > bufferLen) {
            sampleLen = Math.max(0, bufferLen - samplePos);
        }
        float baseSamples = sampleLen;
        float envSamples = 0.0f;
        if (env != null) {
            envSamples = (env.getAttack() + env.getDecay() + env.getRelease()) * sampleRate;
        }
        float totalSamples = baseSamples + envSamples;
        return (int)totalSamples;
    }

    public String toString() {
        return String.format("[Voice %d] dur=%d samples (%.2f ms), bufferRead\u2248%.0f, start=%.2f ms stop=%.2f ms looping=%b", this.voiceId, this.eventSamples, Float.valueOf(this.durationMS), Float.valueOf(this.bufferReadSamples), Float.valueOf(this.startMS), Float.valueOf(this.stopMS), this.looping);
    }
}

