/*
 * Decompiled with CFR 0.152.
 */
package net.paulhertz.pixelaudio.voices;

public class SimpleADSR {
    private float attackTime;
    private float decayTime;
    private float sustainLevel;
    private float releaseTime;
    private float sampleRate = 44100.0f;
    private float attackCurve = 4.0f;
    private float decayCurve = 4.0f;
    private float releaseCurve = 4.0f;
    private Stage stage = Stage.IDLE;
    private float value = 0.0f;
    private float releaseStart = 0.0f;
    private int samplesInStage = 0;
    private int stageSamples = 0;

    public SimpleADSR(float attack, float decay, float sustain, float release) {
        this.attackTime = Math.max(attack, 0.0f);
        this.decayTime = Math.max(decay, 0.0f);
        this.sustainLevel = Math.max(0.0f, Math.min(1.0f, sustain));
        this.releaseTime = Math.max(release, 0.0f);
    }

    public SimpleADSR(float attack, float decay, float sustain, float release, float attackCurve, float decayCurve, float releaseCurve) {
        this(attack, decay, sustain, release);
        this.attackCurve = Math.max(0.1f, attackCurve);
        this.decayCurve = Math.max(0.1f, decayCurve);
        this.releaseCurve = Math.max(0.1f, releaseCurve);
    }

    public void setSampleRate(float sr) {
        if (sr > 0.0f) {
            this.sampleRate = sr;
        }
    }

    public void noteOn() {
        this.stage = Stage.ATTACK;
        this.samplesInStage = 0;
        this.stageSamples = Math.max(1, (int)(this.attackTime * this.sampleRate));
    }

    public void noteOff() {
        this.releaseStart = this.value;
        this.stage = Stage.RELEASE;
        this.samplesInStage = 0;
        this.stageSamples = Math.max(1, (int)(this.releaseTime * this.sampleRate));
    }

    public boolean isFinished() {
        return this.stage == Stage.FINISHED || this.stage == Stage.IDLE;
    }

    public float tick() {
        switch (this.stage) {
            case ATTACK: {
                this.value = SimpleADSR.exponentialInterp(this.samplesInStage, this.stageSamples, 0.0f, 1.0f, this.attackCurve);
                if (++this.samplesInStage < this.stageSamples) break;
                this.stage = Stage.DECAY;
                this.samplesInStage = 0;
                this.stageSamples = Math.max(1, (int)(this.decayTime * this.sampleRate));
                break;
            }
            case DECAY: {
                this.value = SimpleADSR.exponentialInterp(this.samplesInStage, this.stageSamples, 1.0f, this.sustainLevel, this.decayCurve);
                if (++this.samplesInStage < this.stageSamples) break;
                this.stage = Stage.SUSTAIN;
                this.value = this.sustainLevel;
                break;
            }
            case SUSTAIN: {
                this.value = this.sustainLevel;
                break;
            }
            case RELEASE: {
                this.value = SimpleADSR.exponentialInterp(this.samplesInStage, this.stageSamples, this.releaseStart, 0.0f, this.releaseCurve);
                if (++this.samplesInStage < this.stageSamples) break;
                this.stage = Stage.FINISHED;
                this.value = 0.0f;
                break;
            }
            default: {
                this.value = 0.0f;
            }
        }
        return this.value;
    }

    private static float exponentialInterp(int step, int total, float start, float end, float curve) {
        if (total <= 0) {
            return end;
        }
        float t = (float)step / (float)total;
        if (curve == 1.0f) {
            return start + (end - start) * t;
        }
        float shaped = (float)((Math.pow(curve, t) - 1.0) / ((double)curve - 1.0));
        return start + (end - start) * shaped;
    }

    public float getValue() {
        return this.value;
    }

    public void setCurves(float attackC, float decayC, float releaseC) {
        this.attackCurve = Math.max(0.1f, attackC);
        this.decayCurve = Math.max(0.1f, decayC);
        this.releaseCurve = Math.max(0.1f, releaseC);
    }

    public void setTimes(float a, float d, float s, float r) {
        this.attackTime = a;
        this.decayTime = d;
        this.sustainLevel = s;
        this.releaseTime = r;
    }

    private static enum Stage {
        IDLE,
        ATTACK,
        DECAY,
        SUSTAIN,
        RELEASE,
        FINISHED;

    }
}

