import net.paulhertz.pixelaudio.*;

PixelAudio pixelaudio;        // the library that we need to load in setup()
HilbertGen hGen;              // a PixelMapGen child class for making Hilbert curves
PixelAudioMapper mapper;      // a class that uses a PixelMapGen ("gen", for short) to map audio samples to RGB pixels
PImage mapImage;              // a bitmap image for display
int[] colors;                 // a spectrum of colors that will be written along the "signal path" in mapImage

// PixelAudio sketches typically begin like this.
public void setup() {
  size(512, 512);                          // Hilbert curves require dimensions that are powers of 2. 
  pixelaudio = new PixelAudio(this);       // initialize PixelAudio library
  hGen = new HilbertGen(width, height);    // create a Hilbert curve generator (or some other PixelMapGen)
  mapper = new PixelAudioMapper(hGen);     // plug the gen into a PixelAudioMapper object
  mapImage = createImage(width, height, RGB);  // create an image for display
  mapImage.loadPixels();                   // load the image with a spectrum of colors
  // call mapper.plantPixels(). Mapper knows the geometry of the signal path generated by hGen.
  // plantPixels writes RGB colors along the "signal path", i.e., the Hilbert Curve, through mapImage
  mapper.plantPixels(getColors(), mapImage.pixels, 0, mapper.getSize());
  mapImage.updatePixels();
}

public int[] getColors() {
  int[] colorWheel = new int[mapper.getSize()];
  pushStyle();
  colorMode(HSB, colorWheel.length, 100, 100);
  int h = 0;
  for (int i = 0; i < colorWheel.length; i++) {
    colorWheel[i] = color(h, 66, 66);
    h++;
  }
  popStyle();
  return colorWheel;
}

public void draw() {
  image(mapImage, 0, 0);
}

public void keyPressed() {
  switch(key) {
  case 'h':
    println("---- no help whatsoever ----");
    break;
  default:
    break;
  }
}
