/**
<p>Package <code>net.paulhertz.pixelaudio.curves</code> implements light weight classes for Bezier curve modeling.</p>
<p>
 Adapted from IgnoCodeLib Processing library for use with PixelAudio library.
 IgnoCodeLib is available in the Processing contributed libraries and at
 https://paulhertz.net/ignocodelib/ and https://github.com/Ignotus-mago/IgnoCodeLib3
</p>

<ul>
<li>{@link net.paulhertz.pixelaudio.curves.PAVertex2DINF PAVertex2DINF.} provides an interface for line and curve vertices.</li>
<li>{@link net.paulhertz.pixelaudio.curves.PALineVertex PALineVertex} stores a line vertex Interface for line and curve vertices</li>
<li>{@link net.paulhertz.pixelaudio.curves.PABezVertex PABezVertex} provides storage for a cubic Bezier curves's control points and anchor point.</li>
<li>{@link net.paulhertz.pixelaudio.curves.PABezShape PABezShape} stores open or closed paths composed of lines and Bezier curves, and implements attributes and geometric transforms for them.</li>
<li>{@link net.paulhertz.pixelaudio.curves.PACurveMaker PACurveMaker} is a utility and storage class for interactive drawing and curve modeling.</li>
<li>{@link net.paulhertz.pixelaudio.curves.PACurveUtility PACurveUtility} provides static methods that support curve modeling and drawing.</li>
</ul>



*/
package net.paulhertz.pixelaudio.curves;