package net.paulhertz.pixelaudio.voices;

/**
 * Backend engine contract for sampler implementations.
 * Allows swapping implementations without changing higher layers.
 */
public interface PASampler {
	
    /**
     * Play command with all the useful arguments in standard order.
     * 
     * @param samplePos    index into the buffer to start sampling 
     * @param sampleLen    expected duration of the audio event, which is expected to return its actual duration
     * @param amplitude    maximum amplitude of signal generated by the sampler
     * @param env          ADSR style envelope for the entire event
     * @param pitch        pitch multiplier, where 1.0f implies pitch is unchanged and all samples are read
     * @param pan          location of audio event in stereo field, -1.0f = left, 0.0f = center, 1.0f = right
     * @return             actual duration of event in samples, typically sampleLen + envelope release time
     */
    int play(int samplePos, int sampleLen, float amplitude, ADSRParams env, float pitch, float pan);

    /** Returns true if any currently active voice is looping. */
    boolean isLooping();

    /** Stops all voices immediately. */
    void stopAll();

	void setSampleRate(float newRate);
	
	public void setBuffer(float[] buffer);
	
	public void setBuffer(float[] buffer, float playbackSampleRate);
	
}
